package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A reference to a TrustStore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * TrustStoreReference trustStoreReference = TrustStoreReference.builder()
 *         .trustStoreArn("trustStoreArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.001Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TrustStoreReference")
@software.amazon.jsii.Jsii.Proxy(TrustStoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrustStoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The TrustStoreArn of the TrustStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrustStoreArn();

    /**
     * @return a {@link Builder} of {@link TrustStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrustStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrustStoreReference> {
        java.lang.String trustStoreArn;

        /**
         * Sets the value of {@link TrustStoreReference#getTrustStoreArn}
         * @param trustStoreArn The TrustStoreArn of the TrustStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStoreArn(java.lang.String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrustStoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrustStoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrustStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrustStoreReference {
        private final java.lang.String trustStoreArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trustStoreArn = software.amazon.jsii.Kernel.get(this, "trustStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trustStoreArn = java.util.Objects.requireNonNull(builder.trustStoreArn, "trustStoreArn is required");
        }

        @Override
        public final java.lang.String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trustStoreArn", om.valueToTree(this.getTrustStoreArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.TrustStoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrustStoreReference.Jsii$Proxy that = (TrustStoreReference.Jsii$Proxy) o;

            return this.trustStoreArn.equals(that.trustStoreArn);
        }

        @Override
        public final int hashCode() {
            int result = this.trustStoreArn.hashCode();
            return result;
        }
    }
}
