package software.amazon.awscdk.services.emr;

/**
 * A reference to a InstanceGroupConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * InstanceGroupConfigReference instanceGroupConfigReference = InstanceGroupConfigReference.builder()
 *         .instanceGroupConfigId("instanceGroupConfigId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.156Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.InstanceGroupConfigReference")
@software.amazon.jsii.Jsii.Proxy(InstanceGroupConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceGroupConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the InstanceGroupConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceGroupConfigId();

    /**
     * @return a {@link Builder} of {@link InstanceGroupConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceGroupConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceGroupConfigReference> {
        java.lang.String instanceGroupConfigId;

        /**
         * Sets the value of {@link InstanceGroupConfigReference#getInstanceGroupConfigId}
         * @param instanceGroupConfigId The Id of the InstanceGroupConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroupConfigId(java.lang.String instanceGroupConfigId) {
            this.instanceGroupConfigId = instanceGroupConfigId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceGroupConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceGroupConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceGroupConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupConfigReference {
        private final java.lang.String instanceGroupConfigId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceGroupConfigId = software.amazon.jsii.Kernel.get(this, "instanceGroupConfigId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceGroupConfigId = java.util.Objects.requireNonNull(builder.instanceGroupConfigId, "instanceGroupConfigId is required");
        }

        @Override
        public final java.lang.String getInstanceGroupConfigId() {
            return this.instanceGroupConfigId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceGroupConfigId", om.valueToTree(this.getInstanceGroupConfigId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.InstanceGroupConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceGroupConfigReference.Jsii$Proxy that = (InstanceGroupConfigReference.Jsii$Proxy) o;

            return this.instanceGroupConfigId.equals(that.instanceGroupConfigId);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceGroupConfigId.hashCode();
            return result;
        }
    }
}
