package software.amazon.awscdk.services.emr;

/**
 * A reference to a Studio resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * StudioReference studioReference = StudioReference.builder()
 *         .studioArn("studioArn")
 *         .studioId("studioId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.157Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.StudioReference")
@software.amazon.jsii.Jsii.Proxy(StudioReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StudioReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioArn();

    /**
     * The StudioId of the Studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioId();

    /**
     * @return a {@link Builder} of {@link StudioReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StudioReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StudioReference> {
        java.lang.String studioArn;
        java.lang.String studioId;

        /**
         * Sets the value of {@link StudioReference#getStudioArn}
         * @param studioArn The ARN of the Studio resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioArn(java.lang.String studioArn) {
            this.studioArn = studioArn;
            return this;
        }

        /**
         * Sets the value of {@link StudioReference#getStudioId}
         * @param studioId The StudioId of the Studio resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(java.lang.String studioId) {
            this.studioId = studioId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StudioReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StudioReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StudioReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StudioReference {
        private final java.lang.String studioArn;
        private final java.lang.String studioId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.studioArn = software.amazon.jsii.Kernel.get(this, "studioArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioId = software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.studioArn = java.util.Objects.requireNonNull(builder.studioArn, "studioArn is required");
            this.studioId = java.util.Objects.requireNonNull(builder.studioId, "studioId is required");
        }

        @Override
        public final java.lang.String getStudioArn() {
            return this.studioArn;
        }

        @Override
        public final java.lang.String getStudioId() {
            return this.studioId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("studioArn", om.valueToTree(this.getStudioArn()));
            data.set("studioId", om.valueToTree(this.getStudioId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.StudioReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StudioReference.Jsii$Proxy that = (StudioReference.Jsii$Proxy) o;

            if (!studioArn.equals(that.studioArn)) return false;
            return this.studioId.equals(that.studioId);
        }

        @Override
        public final int hashCode() {
            int result = this.studioArn.hashCode();
            result = 31 * result + (this.studioId.hashCode());
            return result;
        }
    }
}
