package software.amazon.awscdk.services.entityresolution;

/**
 * Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be run.
 * <p>
 * Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use the UpdateIdMappingWorkflow API.
 * <p>
 * <blockquote>
 * <p>
 * Incremental processing is not supported for ID mapping workflows.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnIdMappingWorkflow cfnIdMappingWorkflow = CfnIdMappingWorkflow.Builder.create(this, "MyCfnIdMappingWorkflow")
 *         .idMappingTechniques(IdMappingTechniquesProperty.builder()
 *                 .idMappingType("idMappingType")
 *                 .normalizationVersion("normalizationVersion")
 *                 .providerProperties(ProviderPropertiesProperty.builder()
 *                         .providerServiceArn("providerServiceArn")
 *                         // the properties below are optional
 *                         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
 *                                 .intermediateS3Path("intermediateS3Path")
 *                                 .build())
 *                         .providerConfiguration(Map.of(
 *                                 "providerConfigurationKey", "providerConfiguration"))
 *                         .build())
 *                 .ruleBasedProperties(IdMappingRuleBasedPropertiesProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         .recordMatchingModel("recordMatchingModel")
 *                         // the properties below are optional
 *                         .ruleDefinitionType("ruleDefinitionType")
 *                         .rules(List.of(RuleProperty.builder()
 *                                 .matchingKeys(List.of("matchingKeys"))
 *                                 .ruleName("ruleName")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .inputSourceConfig(List.of(IdMappingWorkflowInputSourceProperty.builder()
 *                 .inputSourceArn("inputSourceArn")
 *                 // the properties below are optional
 *                 .schemaArn("schemaArn")
 *                 .type("type")
 *                 .build()))
 *         .roleArn("roleArn")
 *         .workflowName("workflowName")
 *         // the properties below are optional
 *         .description("description")
 *         .idMappingIncrementalRunConfig(IdMappingIncrementalRunConfigProperty.builder()
 *                 .incrementalRunType("incrementalRunType")
 *                 .build())
 *         .outputSourceConfig(List.of(IdMappingWorkflowOutputSourceProperty.builder()
 *                 .outputS3Path("outputS3Path")
 *                 // the properties below are optional
 *                 .kmsArn("kmsArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.176Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow")
public class CfnIdMappingWorkflow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.entityresolution.IIdMappingWorkflowRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdMappingWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdMappingWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdMappingWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new IIdMappingWorkflowRef from a workflowName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param workflowName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.IIdMappingWorkflowRef fromWorkflowName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String workflowName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.class, "fromWorkflowName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.entityresolution.IIdMappingWorkflowRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(workflowName, "workflowName is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time of this IdMappingWorkflow got created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time of this IdMappingWorkflow got last updated at.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default IdMappingWorkflow arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkflowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkflowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a IdMappingWorkflow resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.IdMappingWorkflowReference getIdMappingWorkflowRef() {
        return software.amazon.jsii.Kernel.get(this, "idMappingWorkflowRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.entityresolution.IdMappingWorkflowReference.class));
    }

    /**
     * An object which defines the ID mapping technique and any additional configurations.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIdMappingTechniques() {
        return software.amazon.jsii.Kernel.get(this, "idMappingTechniques", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object which defines the ID mapping technique and any additional configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingTechniques(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "idMappingTechniques", java.util.Objects.requireNonNull(value, "idMappingTechniques is required"));
    }

    /**
     * An object which defines the ID mapping technique and any additional configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingTechniques(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty value) {
        software.amazon.jsii.Kernel.set(this, "idMappingTechniques", java.util.Objects.requireNonNull(value, "idMappingTechniques is required"));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowInputSourceProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputSourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "inputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", java.util.Objects.requireNonNull(value, "inputSourceConfig is required"));
    }

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSourceConfig(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowInputSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowInputSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputSourceConfig", java.util.Objects.requireNonNull(value, "inputSourceConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkflowName() {
        return software.amazon.jsii.Kernel.get(this, "workflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workflowName", java.util.Objects.requireNonNull(value, "workflowName is required"));
    }

    /**
     * A description of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingIncrementalRunConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdMappingIncrementalRunConfig() {
        return software.amazon.jsii.Kernel.get(this, "idMappingIncrementalRunConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingIncrementalRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "idMappingIncrementalRunConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdMappingIncrementalRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingIncrementalRunConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "idMappingIncrementalRunConfig", value);
    }

    /**
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowOutputSourceProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputSourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "outputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputSourceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputSourceConfig", value);
    }

    /**
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputSourceConfig(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowOutputSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowOutputSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "outputSourceConfig", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdMappingIncrementalRunConfigProperty idMappingIncrementalRunConfigProperty = IdMappingIncrementalRunConfigProperty.builder()
     *         .incrementalRunType("incrementalRunType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingincrementalrunconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingincrementalrunconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingIncrementalRunConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingIncrementalRunConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingIncrementalRunConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingincrementalrunconfig.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig-incrementalruntype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingincrementalrunconfig.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig-incrementalruntype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIncrementalRunType();

        /**
         * @return a {@link Builder} of {@link IdMappingIncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingIncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingIncrementalRunConfigProperty> {
            java.lang.String incrementalRunType;

            /**
             * Sets the value of {@link IdMappingIncrementalRunConfigProperty#getIncrementalRunType}
             * @param incrementalRunType the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRunType(java.lang.String incrementalRunType) {
                this.incrementalRunType = incrementalRunType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingIncrementalRunConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingIncrementalRunConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingIncrementalRunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingIncrementalRunConfigProperty {
            private final java.lang.String incrementalRunType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.incrementalRunType = software.amazon.jsii.Kernel.get(this, "incrementalRunType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.incrementalRunType = java.util.Objects.requireNonNull(builder.incrementalRunType, "incrementalRunType is required");
            }

            @Override
            public final java.lang.String getIncrementalRunType() {
                return this.incrementalRunType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("incrementalRunType", om.valueToTree(this.getIncrementalRunType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingIncrementalRunConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingIncrementalRunConfigProperty.Jsii$Proxy that = (IdMappingIncrementalRunConfigProperty.Jsii$Proxy) o;

                return this.incrementalRunType.equals(that.incrementalRunType);
            }

            @Override
            public final int hashCode() {
                int result = this.incrementalRunType.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that defines the list of matching rules to run in an ID mapping workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdMappingRuleBasedPropertiesProperty idMappingRuleBasedPropertiesProperty = IdMappingRuleBasedPropertiesProperty.builder()
     *         .attributeMatchingModel("attributeMatchingModel")
     *         .recordMatchingModel("recordMatchingModel")
     *         // the properties below are optional
     *         .ruleDefinitionType("ruleDefinitionType")
     *         .rules(List.of(RuleProperty.builder()
     *                 .matchingKeys(List.of("matchingKeys"))
     *                 .ruleName("ruleName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingRuleBasedPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingRuleBasedPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingRuleBasedPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> .
         * <p>
         * If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
         * <p>
         * If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-attributematchingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-attributematchingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeMatchingModel();

        /**
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code> , only one record in the source can be matched to the same record in the target.
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code> , multiple records in the source can be matched to one record in the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-recordmatchingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-recordmatchingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordMatchingModel();

        /**
         * The set of rules you can use in an ID mapping workflow.
         * <p>
         * The limitations specified for the source or target to define the match rules must be compatible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-ruledefinitiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-ruledefinitiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleDefinitionType() {
            return null;
        }

        /**
         * The rules that can be used for ID mapping.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.RuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingrulebasedproperties.html#cfn-entityresolution-idmappingworkflow-idmappingrulebasedproperties-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdMappingRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingRuleBasedPropertiesProperty> {
            java.lang.String attributeMatchingModel;
            java.lang.String recordMatchingModel;
            java.lang.String ruleDefinitionType;
            java.lang.Object rules;

            /**
             * Sets the value of {@link IdMappingRuleBasedPropertiesProperty#getAttributeMatchingModel}
             * @param attributeMatchingModel The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code> . This parameter is required.
             *                               If you choose <code>ONE_TO_ONE</code> , the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
             *                               <p>
             *                               If you choose <code>MANY_TO_MANY</code> , the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeMatchingModel(java.lang.String attributeMatchingModel) {
                this.attributeMatchingModel = attributeMatchingModel;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingRuleBasedPropertiesProperty#getRecordMatchingModel}
             * @param recordMatchingModel The type of matching record that is allowed to be used in an ID mapping workflow. This parameter is required.
             *                            If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code> , only one record in the source can be matched to the same record in the target.
             *                            <p>
             *                            If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code> , multiple records in the source can be matched to one record in the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordMatchingModel(java.lang.String recordMatchingModel) {
                this.recordMatchingModel = recordMatchingModel;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingRuleBasedPropertiesProperty#getRuleDefinitionType}
             * @param ruleDefinitionType The set of rules you can use in an ID mapping workflow.
             *                           The limitations specified for the source or target to define the match rules must be compatible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDefinitionType(java.lang.String ruleDefinitionType) {
                this.ruleDefinitionType = ruleDefinitionType;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingRuleBasedPropertiesProperty#getRules}
             * @param rules The rules that can be used for ID mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingRuleBasedPropertiesProperty#getRules}
             * @param rules The rules that can be used for ID mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingRuleBasedPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingRuleBasedPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingRuleBasedPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingRuleBasedPropertiesProperty {
            private final java.lang.String attributeMatchingModel;
            private final java.lang.String recordMatchingModel;
            private final java.lang.String ruleDefinitionType;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeMatchingModel = software.amazon.jsii.Kernel.get(this, "attributeMatchingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordMatchingModel = software.amazon.jsii.Kernel.get(this, "recordMatchingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleDefinitionType = software.amazon.jsii.Kernel.get(this, "ruleDefinitionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeMatchingModel = java.util.Objects.requireNonNull(builder.attributeMatchingModel, "attributeMatchingModel is required");
                this.recordMatchingModel = java.util.Objects.requireNonNull(builder.recordMatchingModel, "recordMatchingModel is required");
                this.ruleDefinitionType = builder.ruleDefinitionType;
                this.rules = builder.rules;
            }

            @Override
            public final java.lang.String getAttributeMatchingModel() {
                return this.attributeMatchingModel;
            }

            @Override
            public final java.lang.String getRecordMatchingModel() {
                return this.recordMatchingModel;
            }

            @Override
            public final java.lang.String getRuleDefinitionType() {
                return this.ruleDefinitionType;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeMatchingModel", om.valueToTree(this.getAttributeMatchingModel()));
                data.set("recordMatchingModel", om.valueToTree(this.getRecordMatchingModel()));
                if (this.getRuleDefinitionType() != null) {
                    data.set("ruleDefinitionType", om.valueToTree(this.getRuleDefinitionType()));
                }
                if (this.getRules() != null) {
                    data.set("rules", om.valueToTree(this.getRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingRuleBasedPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingRuleBasedPropertiesProperty.Jsii$Proxy that = (IdMappingRuleBasedPropertiesProperty.Jsii$Proxy) o;

                if (!attributeMatchingModel.equals(that.attributeMatchingModel)) return false;
                if (!recordMatchingModel.equals(that.recordMatchingModel)) return false;
                if (this.ruleDefinitionType != null ? !this.ruleDefinitionType.equals(that.ruleDefinitionType) : that.ruleDefinitionType != null) return false;
                return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeMatchingModel.hashCode();
                result = 31 * result + (this.recordMatchingModel.hashCode());
                result = 31 * result + (this.ruleDefinitionType != null ? this.ruleDefinitionType.hashCode() : 0);
                result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object which defines the ID mapping technique and any additional configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdMappingTechniquesProperty idMappingTechniquesProperty = IdMappingTechniquesProperty.builder()
     *         .idMappingType("idMappingType")
     *         .normalizationVersion("normalizationVersion")
     *         .providerProperties(ProviderPropertiesProperty.builder()
     *                 .providerServiceArn("providerServiceArn")
     *                 // the properties below are optional
     *                 .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
     *                         .intermediateS3Path("intermediateS3Path")
     *                         .build())
     *                 .providerConfiguration(Map.of(
     *                         "providerConfigurationKey", "providerConfiguration"))
     *                 .build())
     *         .ruleBasedProperties(IdMappingRuleBasedPropertiesProperty.builder()
     *                 .attributeMatchingModel("attributeMatchingModel")
     *                 .recordMatchingModel("recordMatchingModel")
     *                 // the properties below are optional
     *                 .ruleDefinitionType("ruleDefinitionType")
     *                 .rules(List.of(RuleProperty.builder()
     *                         .matchingKeys(List.of("matchingKeys"))
     *                         .ruleName("ruleName")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingTechniquesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingTechniquesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of ID mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-idmappingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-idmappingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdMappingType() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-normalizationversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-normalizationversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNormalizationVersion() {
            return null;
        }

        /**
         * An object which defines any additional configurations required by the provider service.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.ProviderPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-providerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-providerproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderProperties() {
            return null;
        }

        /**
         * An object which defines any additional configurations required by rule-based matching.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingRuleBasedPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-rulebasedproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingtechniques.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques-rulebasedproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleBasedProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdMappingTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingTechniquesProperty> {
            java.lang.String idMappingType;
            java.lang.String normalizationVersion;
            java.lang.Object providerProperties;
            java.lang.Object ruleBasedProperties;

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getIdMappingType}
             * @param idMappingType The type of ID mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idMappingType(java.lang.String idMappingType) {
                this.idMappingType = idMappingType;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getNormalizationVersion}
             * @param normalizationVersion the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder normalizationVersion(java.lang.String normalizationVersion) {
                this.normalizationVersion = normalizationVersion;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getProviderProperties}
             * @param providerProperties An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.IResolvable providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getProviderProperties}
             * @param providerProperties An object which defines any additional configurations required by the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerProperties(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.ProviderPropertiesProperty providerProperties) {
                this.providerProperties = providerProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines any additional configurations required by rule-based matching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.IResolvable ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingTechniquesProperty#getRuleBasedProperties}
             * @param ruleBasedProperties An object which defines any additional configurations required by rule-based matching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleBasedProperties(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingRuleBasedPropertiesProperty ruleBasedProperties) {
                this.ruleBasedProperties = ruleBasedProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingTechniquesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingTechniquesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingTechniquesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingTechniquesProperty {
            private final java.lang.String idMappingType;
            private final java.lang.String normalizationVersion;
            private final java.lang.Object providerProperties;
            private final java.lang.Object ruleBasedProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idMappingType = software.amazon.jsii.Kernel.get(this, "idMappingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.normalizationVersion = software.amazon.jsii.Kernel.get(this, "normalizationVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.providerProperties = software.amazon.jsii.Kernel.get(this, "providerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleBasedProperties = software.amazon.jsii.Kernel.get(this, "ruleBasedProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idMappingType = builder.idMappingType;
                this.normalizationVersion = builder.normalizationVersion;
                this.providerProperties = builder.providerProperties;
                this.ruleBasedProperties = builder.ruleBasedProperties;
            }

            @Override
            public final java.lang.String getIdMappingType() {
                return this.idMappingType;
            }

            @Override
            public final java.lang.String getNormalizationVersion() {
                return this.normalizationVersion;
            }

            @Override
            public final java.lang.Object getProviderProperties() {
                return this.providerProperties;
            }

            @Override
            public final java.lang.Object getRuleBasedProperties() {
                return this.ruleBasedProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdMappingType() != null) {
                    data.set("idMappingType", om.valueToTree(this.getIdMappingType()));
                }
                if (this.getNormalizationVersion() != null) {
                    data.set("normalizationVersion", om.valueToTree(this.getNormalizationVersion()));
                }
                if (this.getProviderProperties() != null) {
                    data.set("providerProperties", om.valueToTree(this.getProviderProperties()));
                }
                if (this.getRuleBasedProperties() != null) {
                    data.set("ruleBasedProperties", om.valueToTree(this.getRuleBasedProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingTechniquesProperty.Jsii$Proxy that = (IdMappingTechniquesProperty.Jsii$Proxy) o;

                if (this.idMappingType != null ? !this.idMappingType.equals(that.idMappingType) : that.idMappingType != null) return false;
                if (this.normalizationVersion != null ? !this.normalizationVersion.equals(that.normalizationVersion) : that.normalizationVersion != null) return false;
                if (this.providerProperties != null ? !this.providerProperties.equals(that.providerProperties) : that.providerProperties != null) return false;
                return this.ruleBasedProperties != null ? this.ruleBasedProperties.equals(that.ruleBasedProperties) : that.ruleBasedProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idMappingType != null ? this.idMappingType.hashCode() : 0;
                result = 31 * result + (this.normalizationVersion != null ? this.normalizationVersion.hashCode() : 0);
                result = 31 * result + (this.providerProperties != null ? this.providerProperties.hashCode() : 0);
                result = 31 * result + (this.ruleBasedProperties != null ? this.ruleBasedProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing <code>inputSourceARN</code> , <code>schemaName</code> , and <code>type</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdMappingWorkflowInputSourceProperty idMappingWorkflowInputSourceProperty = IdMappingWorkflowInputSourceProperty.builder()
     *         .inputSourceArn("inputSourceArn")
     *         // the properties below are optional
     *         .schemaArn("schemaArn")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowInputSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingWorkflowInputSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingWorkflowInputSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-inputsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-inputsourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputSourceArn();

        /**
         * The ARN (Amazon Resource Name) that AWS Entity Resolution generated for the <code>SchemaMapping</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-schemaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-schemaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaArn() {
            return null;
        }

        /**
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code> .
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow.
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will resolve to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowinputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowinputsource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdMappingWorkflowInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingWorkflowInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingWorkflowInputSourceProperty> {
            java.lang.String inputSourceArn;
            java.lang.String schemaArn;
            java.lang.String type;

            /**
             * Sets the value of {@link IdMappingWorkflowInputSourceProperty#getInputSourceArn}
             * @param inputSourceArn An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSourceArn(java.lang.String inputSourceArn) {
                this.inputSourceArn = inputSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingWorkflowInputSourceProperty#getSchemaArn}
             * @param schemaArn The ARN (Amazon Resource Name) that AWS Entity Resolution generated for the <code>SchemaMapping</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaArn(java.lang.String schemaArn) {
                this.schemaArn = schemaArn;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingWorkflowInputSourceProperty#getType}
             * @param type The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code> .
             *             The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow.
             *             <p>
             *             The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will resolve to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingWorkflowInputSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingWorkflowInputSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingWorkflowInputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingWorkflowInputSourceProperty {
            private final java.lang.String inputSourceArn;
            private final java.lang.String schemaArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputSourceArn = software.amazon.jsii.Kernel.get(this, "inputSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaArn = software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSourceArn = java.util.Objects.requireNonNull(builder.inputSourceArn, "inputSourceArn is required");
                this.schemaArn = builder.schemaArn;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getInputSourceArn() {
                return this.inputSourceArn;
            }

            @Override
            public final java.lang.String getSchemaArn() {
                return this.schemaArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputSourceArn", om.valueToTree(this.getInputSourceArn()));
                if (this.getSchemaArn() != null) {
                    data.set("schemaArn", om.valueToTree(this.getSchemaArn()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowInputSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingWorkflowInputSourceProperty.Jsii$Proxy that = (IdMappingWorkflowInputSourceProperty.Jsii$Proxy) o;

                if (!inputSourceArn.equals(that.inputSourceArn)) return false;
                if (this.schemaArn != null ? !this.schemaArn.equals(that.schemaArn) : that.schemaArn != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputSourceArn.hashCode();
                result = 31 * result + (this.schemaArn != null ? this.schemaArn.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IdMappingWorkflowOutputSourceProperty idMappingWorkflowOutputSourceProperty = IdMappingWorkflowOutputSourceProperty.builder()
     *         .outputS3Path("outputS3Path")
     *         // the properties below are optional
     *         .kmsArn("kmsArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowOutputSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(IdMappingWorkflowOutputSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdMappingWorkflowOutputSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 path to which AWS Entity Resolution will write the output table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowoutputsource-outputs3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowoutputsource-outputs3path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputS3Path();

        /**
         * Customer AWS KMS ARN for encryption at rest.
         * <p>
         * If not provided, system will use an AWS Entity Resolution managed KMS key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowoutputsource-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-idmappingworkflowoutputsource.html#cfn-entityresolution-idmappingworkflow-idmappingworkflowoutputsource-kmsarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdMappingWorkflowOutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdMappingWorkflowOutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdMappingWorkflowOutputSourceProperty> {
            java.lang.String outputS3Path;
            java.lang.String kmsArn;

            /**
             * Sets the value of {@link IdMappingWorkflowOutputSourceProperty#getOutputS3Path}
             * @param outputS3Path The S3 path to which AWS Entity Resolution will write the output table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3Path(java.lang.String outputS3Path) {
                this.outputS3Path = outputS3Path;
                return this;
            }

            /**
             * Sets the value of {@link IdMappingWorkflowOutputSourceProperty#getKmsArn}
             * @param kmsArn Customer AWS KMS ARN for encryption at rest.
             *               If not provided, system will use an AWS Entity Resolution managed KMS key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsArn(java.lang.String kmsArn) {
                this.kmsArn = kmsArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdMappingWorkflowOutputSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdMappingWorkflowOutputSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdMappingWorkflowOutputSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingWorkflowOutputSourceProperty {
            private final java.lang.String outputS3Path;
            private final java.lang.String kmsArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputS3Path = software.amazon.jsii.Kernel.get(this, "outputS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputS3Path = java.util.Objects.requireNonNull(builder.outputS3Path, "outputS3Path is required");
                this.kmsArn = builder.kmsArn;
            }

            @Override
            public final java.lang.String getOutputS3Path() {
                return this.outputS3Path;
            }

            @Override
            public final java.lang.String getKmsArn() {
                return this.kmsArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputS3Path", om.valueToTree(this.getOutputS3Path()));
                if (this.getKmsArn() != null) {
                    data.set("kmsArn", om.valueToTree(this.getKmsArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IdMappingWorkflowOutputSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdMappingWorkflowOutputSourceProperty.Jsii$Proxy that = (IdMappingWorkflowOutputSourceProperty.Jsii$Proxy) o;

                if (!outputS3Path.equals(that.outputS3Path)) return false;
                return this.kmsArn != null ? this.kmsArn.equals(that.kmsArn) : that.kmsArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputS3Path.hashCode();
                result = 31 * result + (this.kmsArn != null ? this.kmsArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 location that temporarily stores your data while it processes.
     * <p>
     * Your information won't be saved permanently.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * IntermediateSourceConfigurationProperty intermediateSourceConfigurationProperty = IntermediateSourceConfigurationProperty.builder()
     *         .intermediateS3Path("intermediateS3Path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-intermediatesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-intermediatesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IntermediateSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntermediateSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntermediateSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 location (bucket and prefix).
         * <p>
         * For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-intermediatesourceconfiguration.html#cfn-entityresolution-idmappingworkflow-intermediatesourceconfiguration-intermediates3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-intermediatesourceconfiguration.html#cfn-entityresolution-idmappingworkflow-intermediatesourceconfiguration-intermediates3path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateS3Path();

        /**
         * @return a {@link Builder} of {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntermediateSourceConfigurationProperty> {
            java.lang.String intermediateS3Path;

            /**
             * Sets the value of {@link IntermediateSourceConfigurationProperty#getIntermediateS3Path}
             * @param intermediateS3Path The Amazon S3 location (bucket and prefix). This parameter is required.
             *                           For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateS3Path(java.lang.String intermediateS3Path) {
                this.intermediateS3Path = intermediateS3Path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntermediateSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntermediateSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntermediateSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntermediateSourceConfigurationProperty {
            private final java.lang.String intermediateS3Path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateS3Path = software.amazon.jsii.Kernel.get(this, "intermediateS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateS3Path = java.util.Objects.requireNonNull(builder.intermediateS3Path, "intermediateS3Path is required");
            }

            @Override
            public final java.lang.String getIntermediateS3Path() {
                return this.intermediateS3Path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateS3Path", om.valueToTree(this.getIntermediateS3Path()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.IntermediateSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntermediateSourceConfigurationProperty.Jsii$Proxy that = (IntermediateSourceConfigurationProperty.Jsii$Proxy) o;

                return this.intermediateS3Path.equals(that.intermediateS3Path);
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateS3Path.hashCode();
                return result;
            }
        }
    }
    /**
     * An object containing the <code>providerServiceARN</code> , <code>intermediateSourceConfiguration</code> , and <code>providerConfiguration</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * ProviderPropertiesProperty providerPropertiesProperty = ProviderPropertiesProperty.builder()
     *         .providerServiceArn("providerServiceArn")
     *         // the properties below are optional
     *         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
     *                 .intermediateS3Path("intermediateS3Path")
     *                 .build())
     *         .providerConfiguration(Map.of(
     *                 "providerConfigurationKey", "providerConfiguration"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.ProviderPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProviderPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProviderPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the provider service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-providerservicearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-providerservicearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderServiceArn();

        /**
         * The Amazon S3 location that temporarily stores your data while it processes.
         * <p>
         * Your information won't be saved permanently.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IntermediateSourceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-intermediatesourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-intermediatesourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntermediateSourceConfiguration() {
            return null;
        }

        /**
         * The required configuration fields to use with the provider service.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-providerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-providerproperties.html#cfn-entityresolution-idmappingworkflow-providerproperties-providerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProviderConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProviderPropertiesProperty> {
            java.lang.String providerServiceArn;
            java.lang.Object intermediateSourceConfiguration;
            java.lang.Object providerConfiguration;

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderServiceArn}
             * @param providerServiceArn The ARN of the provider service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerServiceArn(java.lang.String providerServiceArn) {
                this.providerServiceArn = providerServiceArn;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getIntermediateSourceConfiguration}
             * @param intermediateSourceConfiguration The Amazon S3 location that temporarily stores your data while it processes.
             *                                        Your information won't be saved permanently.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateSourceConfiguration(software.amazon.awscdk.IResolvable intermediateSourceConfiguration) {
                this.intermediateSourceConfiguration = intermediateSourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getIntermediateSourceConfiguration}
             * @param intermediateSourceConfiguration The Amazon S3 location that temporarily stores your data while it processes.
             *                                        Your information won't be saved permanently.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateSourceConfiguration(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IntermediateSourceConfigurationProperty intermediateSourceConfiguration) {
                this.intermediateSourceConfiguration = intermediateSourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration The required configuration fields to use with the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(java.util.Map<java.lang.String, java.lang.String> providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProviderPropertiesProperty#getProviderConfiguration}
             * @param providerConfiguration The required configuration fields to use with the provider service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerConfiguration(software.amazon.awscdk.IResolvable providerConfiguration) {
                this.providerConfiguration = providerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProviderPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProviderPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProviderPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderPropertiesProperty {
            private final java.lang.String providerServiceArn;
            private final java.lang.Object intermediateSourceConfiguration;
            private final java.lang.Object providerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerServiceArn = software.amazon.jsii.Kernel.get(this, "providerServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.intermediateSourceConfiguration = software.amazon.jsii.Kernel.get(this, "intermediateSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.providerConfiguration = software.amazon.jsii.Kernel.get(this, "providerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerServiceArn = java.util.Objects.requireNonNull(builder.providerServiceArn, "providerServiceArn is required");
                this.intermediateSourceConfiguration = builder.intermediateSourceConfiguration;
                this.providerConfiguration = builder.providerConfiguration;
            }

            @Override
            public final java.lang.String getProviderServiceArn() {
                return this.providerServiceArn;
            }

            @Override
            public final java.lang.Object getIntermediateSourceConfiguration() {
                return this.intermediateSourceConfiguration;
            }

            @Override
            public final java.lang.Object getProviderConfiguration() {
                return this.providerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerServiceArn", om.valueToTree(this.getProviderServiceArn()));
                if (this.getIntermediateSourceConfiguration() != null) {
                    data.set("intermediateSourceConfiguration", om.valueToTree(this.getIntermediateSourceConfiguration()));
                }
                if (this.getProviderConfiguration() != null) {
                    data.set("providerConfiguration", om.valueToTree(this.getProviderConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.ProviderPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProviderPropertiesProperty.Jsii$Proxy that = (ProviderPropertiesProperty.Jsii$Proxy) o;

                if (!providerServiceArn.equals(that.providerServiceArn)) return false;
                if (this.intermediateSourceConfiguration != null ? !this.intermediateSourceConfiguration.equals(that.intermediateSourceConfiguration) : that.intermediateSourceConfiguration != null) return false;
                return this.providerConfiguration != null ? this.providerConfiguration.equals(that.providerConfiguration) : that.providerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerServiceArn.hashCode();
                result = 31 * result + (this.intermediateSourceConfiguration != null ? this.intermediateSourceConfiguration.hashCode() : 0);
                result = 31 * result + (this.providerConfiguration != null ? this.providerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object containing the <code>ruleName</code> and <code>matchingKeys</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.entityresolution.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .matchingKeys(List.of("matchingKeys"))
     *         .ruleName("ruleName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of <code>MatchingKeys</code> .
         * <p>
         * The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html#cfn-entityresolution-idmappingworkflow-rule-matchingkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html#cfn-entityresolution-idmappingworkflow-rule-matchingkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingKeys();

        /**
         * A name for the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html#cfn-entityresolution-idmappingworkflow-rule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-entityresolution-idmappingworkflow-rule.html#cfn-entityresolution-idmappingworkflow-rule-rulename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.util.List<java.lang.String> matchingKeys;
            java.lang.String ruleName;

            /**
             * Sets the value of {@link RuleProperty#getMatchingKeys}
             * @param matchingKeys A list of <code>MatchingKeys</code> . This parameter is required.
             *                     The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code> . Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingKeys(java.util.List<java.lang.String> matchingKeys) {
                this.matchingKeys = matchingKeys;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRuleName}
             * @param ruleName A name for the matching rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.util.List<java.lang.String> matchingKeys;
            private final java.lang.String ruleName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingKeys = software.amazon.jsii.Kernel.get(this, "matchingKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingKeys = java.util.Objects.requireNonNull(builder.matchingKeys, "matchingKeys is required");
                this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingKeys() {
                return this.matchingKeys;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingKeys", om.valueToTree(this.getMatchingKeys()));
                data.set("ruleName", om.valueToTree(this.getRuleName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflow.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!matchingKeys.equals(that.matchingKeys)) return false;
                return this.ruleName.equals(that.ruleName);
            }

            @Override
            public final int hashCode() {
                int result = this.matchingKeys.hashCode();
                result = 31 * result + (this.ruleName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflowProps.Builder();
        }

        /**
         * An object which defines the ID mapping technique and any additional configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques</a>
         * @param idMappingTechniques An object which defines the ID mapping technique and any additional configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTechniques(final software.amazon.awscdk.IResolvable idMappingTechniques) {
            this.props.idMappingTechniques(idMappingTechniques);
            return this;
        }
        /**
         * An object which defines the ID mapping technique and any additional configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques</a>
         * @param idMappingTechniques An object which defines the ID mapping technique and any additional configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTechniques(final software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty idMappingTechniques) {
            this.props.idMappingTechniques(idMappingTechniques);
            return this;
        }

        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final software.amazon.awscdk.IResolvable inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }
        /**
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig</a>
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(final java.util.List<? extends java.lang.Object> inputSourceConfig) {
            this.props.inputSourceConfig(inputSourceConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         * <p>
         * AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The name of the workflow.
         * <p>
         * There can't be multiple <code>IdMappingWorkflows</code> with the same name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-workflowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-workflowname</a>
         * @param workflowName The name of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowName(final java.lang.String workflowName) {
            this.props.workflowName(workflowName);
            return this;
        }

        /**
         * A description of the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-description</a>
         * @param description A description of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig</a>
         * @param idMappingIncrementalRunConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingIncrementalRunConfig(final software.amazon.awscdk.IResolvable idMappingIncrementalRunConfig) {
            this.props.idMappingIncrementalRunConfig(idMappingIncrementalRunConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingincrementalrunconfig</a>
         * @param idMappingIncrementalRunConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingIncrementalRunConfig(final software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingIncrementalRunConfigProperty idMappingIncrementalRunConfig) {
            this.props.idMappingIncrementalRunConfig(idMappingIncrementalRunConfig);
            return this;
        }

        /**
         * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig</a>
         * @param outputSourceConfig A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(final software.amazon.awscdk.IResolvable outputSourceConfig) {
            this.props.outputSourceConfig(outputSourceConfig);
            return this;
        }
        /**
         * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig</a>
         * @param outputSourceConfig A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>outputS3Path</code> and <code>KMSArn</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(final java.util.List<? extends java.lang.Object> outputSourceConfig) {
            this.props.outputSourceConfig(outputSourceConfig);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow build() {
            return new software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
