package software.amazon.awscdk.services.entityresolution;

/**
 * A reference to a IdNamespace resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * IdNamespaceReference idNamespaceReference = IdNamespaceReference.builder()
 *         .idNamespaceArn("idNamespaceArn")
 *         .idNamespaceName("idNamespaceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.217Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.IdNamespaceReference")
@software.amazon.jsii.Jsii.Proxy(IdNamespaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdNamespaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IdNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdNamespaceArn();

    /**
     * The IdNamespaceName of the IdNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdNamespaceName();

    /**
     * @return a {@link Builder} of {@link IdNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdNamespaceReference> {
        java.lang.String idNamespaceArn;
        java.lang.String idNamespaceName;

        /**
         * Sets the value of {@link IdNamespaceReference#getIdNamespaceArn}
         * @param idNamespaceArn The ARN of the IdNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idNamespaceArn(java.lang.String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
            return this;
        }

        /**
         * Sets the value of {@link IdNamespaceReference#getIdNamespaceName}
         * @param idNamespaceName The IdNamespaceName of the IdNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idNamespaceName(java.lang.String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdNamespaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdNamespaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdNamespaceReference {
        private final java.lang.String idNamespaceArn;
        private final java.lang.String idNamespaceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.idNamespaceArn = software.amazon.jsii.Kernel.get(this, "idNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idNamespaceName = software.amazon.jsii.Kernel.get(this, "idNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.idNamespaceArn = java.util.Objects.requireNonNull(builder.idNamespaceArn, "idNamespaceArn is required");
            this.idNamespaceName = java.util.Objects.requireNonNull(builder.idNamespaceName, "idNamespaceName is required");
        }

        @Override
        public final java.lang.String getIdNamespaceArn() {
            return this.idNamespaceArn;
        }

        @Override
        public final java.lang.String getIdNamespaceName() {
            return this.idNamespaceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("idNamespaceArn", om.valueToTree(this.getIdNamespaceArn()));
            data.set("idNamespaceName", om.valueToTree(this.getIdNamespaceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.IdNamespaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdNamespaceReference.Jsii$Proxy that = (IdNamespaceReference.Jsii$Proxy) o;

            if (!idNamespaceArn.equals(that.idNamespaceArn)) return false;
            return this.idNamespaceName.equals(that.idNamespaceName);
        }

        @Override
        public final int hashCode() {
            int result = this.idNamespaceArn.hashCode();
            result = 31 * result + (this.idNamespaceName.hashCode());
            return result;
        }
    }
}
