package software.amazon.awscdk.services.events;

/**
 * A reference to a ApiDestination resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * ApiDestinationReference apiDestinationReference = ApiDestinationReference.builder()
 *         .apiDestinationArn("apiDestinationArn")
 *         .apiDestinationName("apiDestinationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.ApiDestinationReference")
@software.amazon.jsii.Jsii.Proxy(ApiDestinationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiDestinationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ApiDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiDestinationArn();

    /**
     * The Name of the ApiDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiDestinationName();

    /**
     * @return a {@link Builder} of {@link ApiDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiDestinationReference> {
        java.lang.String apiDestinationArn;
        java.lang.String apiDestinationName;

        /**
         * Sets the value of {@link ApiDestinationReference#getApiDestinationArn}
         * @param apiDestinationArn The ARN of the ApiDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDestinationArn(java.lang.String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationReference#getApiDestinationName}
         * @param apiDestinationName The Name of the ApiDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDestinationName(java.lang.String apiDestinationName) {
            this.apiDestinationName = apiDestinationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiDestinationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiDestinationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiDestinationReference {
        private final java.lang.String apiDestinationArn;
        private final java.lang.String apiDestinationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiDestinationArn = software.amazon.jsii.Kernel.get(this, "apiDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiDestinationName = software.amazon.jsii.Kernel.get(this, "apiDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiDestinationArn = java.util.Objects.requireNonNull(builder.apiDestinationArn, "apiDestinationArn is required");
            this.apiDestinationName = java.util.Objects.requireNonNull(builder.apiDestinationName, "apiDestinationName is required");
        }

        @Override
        public final java.lang.String getApiDestinationArn() {
            return this.apiDestinationArn;
        }

        @Override
        public final java.lang.String getApiDestinationName() {
            return this.apiDestinationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiDestinationArn", om.valueToTree(this.getApiDestinationArn()));
            data.set("apiDestinationName", om.valueToTree(this.getApiDestinationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.ApiDestinationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiDestinationReference.Jsii$Proxy that = (ApiDestinationReference.Jsii$Proxy) o;

            if (!apiDestinationArn.equals(that.apiDestinationArn)) return false;
            return this.apiDestinationName.equals(that.apiDestinationName);
        }

        @Override
        public final int hashCode() {
            int result = this.apiDestinationArn.hashCode();
            result = 31 * result + (this.apiDestinationName.hashCode());
            return result;
        }
    }
}
