package software.amazon.awscdk.services.events;

/**
 * A reference to a EventBus resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * EventBusReference eventBusReference = EventBusReference.builder()
 *         .eventBusArn("eventBusArn")
 *         .eventBusName("eventBusName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.313Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.EventBusReference")
@software.amazon.jsii.Jsii.Proxy(EventBusReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBusReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the EventBus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn();

    /**
     * The Name of the EventBus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusName();

    /**
     * @return a {@link Builder} of {@link EventBusReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBusReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBusReference> {
        java.lang.String eventBusArn;
        java.lang.String eventBusName;

        /**
         * Sets the value of {@link EventBusReference#getEventBusArn}
         * @param eventBusArn The ARN of the EventBus resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusArn(java.lang.String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        /**
         * Sets the value of {@link EventBusReference#getEventBusName}
         * @param eventBusName The Name of the EventBus resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBusReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBusReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventBusReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBusReference {
        private final java.lang.String eventBusArn;
        private final java.lang.String eventBusName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventBusArn = software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventBusArn = java.util.Objects.requireNonNull(builder.eventBusArn, "eventBusArn is required");
            this.eventBusName = java.util.Objects.requireNonNull(builder.eventBusName, "eventBusName is required");
        }

        @Override
        public final java.lang.String getEventBusArn() {
            return this.eventBusArn;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventBusArn", om.valueToTree(this.getEventBusArn()));
            data.set("eventBusName", om.valueToTree(this.getEventBusName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.EventBusReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBusReference.Jsii$Proxy that = (EventBusReference.Jsii$Proxy) o;

            if (!eventBusArn.equals(that.eventBusArn)) return false;
            return this.eventBusName.equals(that.eventBusName);
        }

        @Override
        public final int hashCode() {
            int result = this.eventBusArn.hashCode();
            result = 31 * result + (this.eventBusName.hashCode());
            return result;
        }
    }
}
