package software.amazon.awscdk.services.events.targets;

/**
 * Customize the Amazon Data Firehose Stream Event Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * DeliveryStream stream = DeliveryStream.Builder.create(this, "DeliveryStream")
 *         .destination(new S3Bucket(bucket))
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.expression("rate(1 minute)"))
 *         .build();
 * rule.addTarget(new FirehoseDeliveryStream(stream));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.368Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.FirehoseDeliveryStream")
public class FirehoseDeliveryStream extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected FirehoseDeliveryStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseDeliveryStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param deliveryStream This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseDeliveryStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.FirehoseDeliveryStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(deliveryStream, "deliveryStream is required"), props });
    }

    /**
     * @param deliveryStream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseDeliveryStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(deliveryStream, "deliveryStream is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.FirehoseDeliveryStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.FirehoseDeliveryStream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param deliveryStream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
            return new Builder(deliveryStream);
        }

        private final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream;
        private software.amazon.awscdk.services.events.targets.FirehoseDeliveryStreamProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        /**
         * The message to send to the stream.
         * <p>
         * Must be a valid JSON text passed to the target stream.
         * <p>
         * Default: - the entire Event Bridge event
         * <p>
         * @return {@code this}
         * @param message The message to send to the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(final software.amazon.awscdk.services.events.RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.FirehoseDeliveryStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.FirehoseDeliveryStream build() {
            return new software.amazon.awscdk.services.events.targets.FirehoseDeliveryStream(
                this.deliveryStream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.FirehoseDeliveryStreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.FirehoseDeliveryStreamProps.Builder();
            }
            return this.props;
        }
    }
}
