package software.amazon.awscdk.services.fis;

/**
 * A reference to a TargetAccountConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fis.*;
 * TargetAccountConfigurationReference targetAccountConfigurationReference = TargetAccountConfigurationReference.builder()
 *         .accountId("accountId")
 *         .experimentTemplateId("experimentTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.482Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.TargetAccountConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(TargetAccountConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetAccountConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AccountId of the TargetAccountConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

    /**
     * The ExperimentTemplateId of the TargetAccountConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExperimentTemplateId();

    /**
     * @return a {@link Builder} of {@link TargetAccountConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetAccountConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TargetAccountConfigurationReference> {
        java.lang.String accountId;
        java.lang.String experimentTemplateId;

        /**
         * Sets the value of {@link TargetAccountConfigurationReference#getAccountId}
         * @param accountId The AccountId of the TargetAccountConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link TargetAccountConfigurationReference#getExperimentTemplateId}
         * @param experimentTemplateId The ExperimentTemplateId of the TargetAccountConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentTemplateId(java.lang.String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetAccountConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TargetAccountConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TargetAccountConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetAccountConfigurationReference {
        private final java.lang.String accountId;
        private final java.lang.String experimentTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.experimentTemplateId = software.amazon.jsii.Kernel.get(this, "experimentTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = java.util.Objects.requireNonNull(builder.accountId, "accountId is required");
            this.experimentTemplateId = java.util.Objects.requireNonNull(builder.experimentTemplateId, "experimentTemplateId is required");
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountId", om.valueToTree(this.getAccountId()));
            data.set("experimentTemplateId", om.valueToTree(this.getExperimentTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.TargetAccountConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetAccountConfigurationReference.Jsii$Proxy that = (TargetAccountConfigurationReference.Jsii$Proxy) o;

            if (!accountId.equals(that.accountId)) return false;
            return this.experimentTemplateId.equals(that.experimentTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.accountId.hashCode();
            result = 31 * result + (this.experimentTemplateId.hashCode());
            return result;
        }
    }
}
