package software.amazon.awscdk.services.frauddetector;

/**
 * A reference to a Outcome resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.frauddetector.*;
 * OutcomeReference outcomeReference = OutcomeReference.builder()
 *         .outcomeArn("outcomeArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.OutcomeReference")
@software.amazon.jsii.Jsii.Proxy(OutcomeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OutcomeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the Outcome resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutcomeArn();

    /**
     * @return a {@link Builder} of {@link OutcomeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OutcomeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OutcomeReference> {
        java.lang.String outcomeArn;

        /**
         * Sets the value of {@link OutcomeReference#getOutcomeArn}
         * @param outcomeArn The Arn of the Outcome resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outcomeArn(java.lang.String outcomeArn) {
            this.outcomeArn = outcomeArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OutcomeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OutcomeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OutcomeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutcomeReference {
        private final java.lang.String outcomeArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.outcomeArn = software.amazon.jsii.Kernel.get(this, "outcomeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outcomeArn = java.util.Objects.requireNonNull(builder.outcomeArn, "outcomeArn is required");
        }

        @Override
        public final java.lang.String getOutcomeArn() {
            return this.outcomeArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("outcomeArn", om.valueToTree(this.getOutcomeArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_frauddetector.OutcomeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OutcomeReference.Jsii$Proxy that = (OutcomeReference.Jsii$Proxy) o;

            return this.outcomeArn.equals(that.outcomeArn);
        }

        @Override
        public final int hashCode() {
            int result = this.outcomeArn.hashCode();
            return result;
        }
    }
}
