package software.amazon.awscdk.services.fsx;

/**
 * Creates an Amazon FSx for Lustre data repository association (DRA).
 * <p>
 * A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding <code>scratch_1</code> deployment type.
 * <p>
 * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html">Linking your file system to an S3 bucket</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnDataRepositoryAssociation cfnDataRepositoryAssociation = CfnDataRepositoryAssociation.Builder.create(this, "MyCfnDataRepositoryAssociation")
 *         .dataRepositoryPath("dataRepositoryPath")
 *         .fileSystemId("fileSystemId")
 *         .fileSystemPath("fileSystemPath")
 *         // the properties below are optional
 *         .batchImportMetaDataOnCreate(false)
 *         .importedFileChunkSize(123)
 *         .s3(S3Property.builder()
 *                 .autoExportPolicy(AutoExportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .autoImportPolicy(AutoImportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.564Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation")
public class CfnDataRepositoryAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.fsx.IDataRepositoryAssociationRef, software.amazon.awscdk.ITaggable {

    protected CfnDataRepositoryAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataRepositoryAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataRepositoryAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the data repository association's system generated Association ID.
     * <p>
     * Example: <code>dra-abcdef0123456789d</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the data repository association's Amazon Resource Name (ARN).
     * <p>
     * Example: <code>arn:aws:fsx:us-east-1:111122223333:association/fs-abc012345def6789a/dra-abcdef0123456789b</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DataRepositoryAssociation resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.DataRepositoryAssociationReference getDataRepositoryAssociationRef() {
        return software.amazon.jsii.Kernel.get(this, "dataRepositoryAssociationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.DataRepositoryAssociationReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The path to the Amazon S3 data repository that will be linked to the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataRepositoryPath() {
        return software.amazon.jsii.Kernel.get(this, "dataRepositoryPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path to the Amazon S3 data repository that will be linked to the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataRepositoryPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataRepositoryPath", java.util.Objects.requireNonNull(value, "dataRepositoryPath is required"));
    }

    /**
     * The ID of the file system on which the data repository association is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the file system on which the data repository association is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemId", java.util.Objects.requireNonNull(value, "fileSystemId is required"));
    }

    /**
     * A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as <code>/ns1/</code> ) or subdirectory (such as <code>/ns1/subdir/</code> ) that will be mapped 1-1 with <code>DataRepositoryPath</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemPath() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as <code>/ns1/</code> ) or subdirectory (such as <code>/ns1/subdir/</code> ) that will be mapped 1-1 with <code>DataRepositoryPath</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemPath", java.util.Objects.requireNonNull(value, "fileSystemPath is required"));
    }

    /**
     * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBatchImportMetaDataOnCreate() {
        return software.amazon.jsii.Kernel.get(this, "batchImportMetaDataOnCreate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBatchImportMetaDataOnCreate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "batchImportMetaDataOnCreate", value);
    }

    /**
     * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBatchImportMetaDataOnCreate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "batchImportMetaDataOnCreate", value);
    }

    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSize() {
        return software.amazon.jsii.Kernel.get(this, "importedFileChunkSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportedFileChunkSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "importedFileChunkSize", value);
    }

    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
        return software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3", value);
    }

    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property value) {
        software.amazon.jsii.Kernel.set(this, "s3", value);
    }

    /**
     * A list of <code>Tag</code> values, with a maximum of 50 elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of <code>Tag</code> values, with a maximum of 50 elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes a data repository association's automatic export policy.
     * <p>
     * The <code>AutoExportPolicy</code> defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx for Lustre automatically exports the defined changes asynchronously once your application finishes modifying the file.
     * <p>
     * The <code>AutoExportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AutoExportPolicyProperty autoExportPolicyProperty = AutoExportPolicyProperty.builder()
     *         .events(List.of("events"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoexportpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoexportpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoExportPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoExportPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <code>AutoExportPolicy</code> can have the following event values:.
         * <p>
         * <ul>
         * <li><code>NEW</code> - New files and directories are automatically exported to the data repository as they are added to the file system.</li>
         * <li><code>CHANGED</code> - Changes to files and directories on the file system are automatically exported to the data repository.</li>
         * <li><code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are deleted on the file system.</li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoExportPolicy</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoexportpolicy.html#cfn-fsx-datarepositoryassociation-autoexportpolicy-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoexportpolicy.html#cfn-fsx-datarepositoryassociation-autoexportpolicy-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoExportPolicyProperty> {
            java.util.List<java.lang.String> events;

            /**
             * Sets the value of {@link AutoExportPolicyProperty#getEvents}
             * @param events The <code>AutoExportPolicy</code> can have the following event values:. This parameter is required.
             *               <ul>
             *               <li><code>NEW</code> - New files and directories are automatically exported to the data repository as they are added to the file system.</li>
             *               <li><code>CHANGED</code> - Changes to files and directories on the file system are automatically exported to the data repository.</li>
             *               <li><code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are deleted on the file system.</li>
             *               </ul>
             *               <p>
             *               You can define any combination of event types for your <code>AutoExportPolicy</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoExportPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoExportPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoExportPolicyProperty {
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("events", om.valueToTree(this.getEvents()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoExportPolicyProperty.Jsii$Proxy that = (AutoExportPolicyProperty.Jsii$Proxy) o;

                return this.events.equals(that.events);
            }

            @Override
            public final int hashCode() {
                int result = this.events.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the data repository association's automatic import policy.
     * <p>
     * The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your Amazon FSx for Lustre file system as you modify objects in a linked S3 bucket.
     * <p>
     * The <code>AutoImportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AutoImportPolicyProperty autoImportPolicyProperty = AutoImportPolicyProperty.builder()
     *         .events(List.of("events"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoImportPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoImportPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <code>AutoImportPolicy</code> can have the following event values:.
         * <p>
         * <ul>
         * <li><code>NEW</code> - Amazon FSx automatically imports metadata of files added to the linked S3 bucket that do not currently exist in the FSx file system.</li>
         * <li><code>CHANGED</code> - Amazon FSx automatically updates file metadata and invalidates existing file content on the file system as files change in the data repository.</li>
         * <li><code>DELETED</code> - Amazon FSx automatically deletes files on the file system as corresponding files are deleted in the data repository.</li>
         * </ul>
         * <p>
         * You can define any combination of event types for your <code>AutoImportPolicy</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html#cfn-fsx-datarepositoryassociation-autoimportpolicy-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html#cfn-fsx-datarepositoryassociation-autoimportpolicy-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoImportPolicyProperty> {
            java.util.List<java.lang.String> events;

            /**
             * Sets the value of {@link AutoImportPolicyProperty#getEvents}
             * @param events The <code>AutoImportPolicy</code> can have the following event values:. This parameter is required.
             *               <ul>
             *               <li><code>NEW</code> - Amazon FSx automatically imports metadata of files added to the linked S3 bucket that do not currently exist in the FSx file system.</li>
             *               <li><code>CHANGED</code> - Amazon FSx automatically updates file metadata and invalidates existing file content on the file system as files change in the data repository.</li>
             *               <li><code>DELETED</code> - Amazon FSx automatically deletes files on the file system as corresponding files are deleted in the data repository.</li>
             *               </ul>
             *               <p>
             *               You can define any combination of event types for your <code>AutoImportPolicy</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoImportPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoImportPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoImportPolicyProperty {
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("events", om.valueToTree(this.getEvents()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoImportPolicyProperty.Jsii$Proxy that = (AutoImportPolicyProperty.Jsii$Proxy) o;

                return this.events.equals(that.events);
            }

            @Override
            public final int hashCode() {
                int result = this.events.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
     * <p>
     * The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * S3Property s3Property = S3Property.builder()
     *         .autoExportPolicy(AutoExportPolicyProperty.builder()
     *                 .events(List.of("events"))
     *                 .build())
     *         .autoImportPolicy(AutoImportPolicyProperty.builder()
     *                 .events(List.of("events"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes a data repository association's automatic export policy.
         * <p>
         * The <code>AutoExportPolicy</code> defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx for Lustre automatically exports the defined changes asynchronously once your application finishes modifying the file.
         * <p>
         * The <code>AutoExportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html#cfn-fsx-datarepositoryassociation-s3-autoexportpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html#cfn-fsx-datarepositoryassociation-s3-autoexportpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoExportPolicy() {
            return null;
        }

        /**
         * Describes the data repository association's automatic import policy.
         * <p>
         * The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your Amazon FSx for Lustre file system as you modify objects in a linked S3 bucket.
         * <p>
         * The <code>AutoImportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html#cfn-fsx-datarepositoryassociation-s3-autoimportpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-s3.html#cfn-fsx-datarepositoryassociation-s3-autoimportpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoImportPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            java.lang.Object autoExportPolicy;
            java.lang.Object autoImportPolicy;

            /**
             * Sets the value of {@link S3Property#getAutoExportPolicy}
             * @param autoExportPolicy Describes a data repository association's automatic export policy.
             *                         The <code>AutoExportPolicy</code> defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx for Lustre automatically exports the defined changes asynchronously once your application finishes modifying the file.
             *                         <p>
             *                         The <code>AutoExportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoExportPolicy(software.amazon.awscdk.IResolvable autoExportPolicy) {
                this.autoExportPolicy = autoExportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoExportPolicy}
             * @param autoExportPolicy Describes a data repository association's automatic export policy.
             *                         The <code>AutoExportPolicy</code> defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx for Lustre automatically exports the defined changes asynchronously once your application finishes modifying the file.
             *                         <p>
             *                         The <code>AutoExportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoExportPolicy(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty autoExportPolicy) {
                this.autoExportPolicy = autoExportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoImportPolicy}
             * @param autoImportPolicy Describes the data repository association's automatic import policy.
             *                         The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your Amazon FSx for Lustre file system as you modify objects in a linked S3 bucket.
             *                         <p>
             *                         The <code>AutoImportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(software.amazon.awscdk.IResolvable autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoImportPolicy}
             * @param autoImportPolicy Describes the data repository association's automatic import policy.
             *                         The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your Amazon FSx for Lustre file system as you modify objects in a linked S3 bucket.
             *                         <p>
             *                         The <code>AutoImportPolicy</code> is only supported on Amazon FSx for Lustre file systems with a data repository association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.Object autoExportPolicy;
            private final java.lang.Object autoImportPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoExportPolicy = software.amazon.jsii.Kernel.get(this, "autoExportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoImportPolicy = software.amazon.jsii.Kernel.get(this, "autoImportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoExportPolicy = builder.autoExportPolicy;
                this.autoImportPolicy = builder.autoImportPolicy;
            }

            @Override
            public final java.lang.Object getAutoExportPolicy() {
                return this.autoExportPolicy;
            }

            @Override
            public final java.lang.Object getAutoImportPolicy() {
                return this.autoImportPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoExportPolicy() != null) {
                    data.set("autoExportPolicy", om.valueToTree(this.getAutoExportPolicy()));
                }
                if (this.getAutoImportPolicy() != null) {
                    data.set("autoImportPolicy", om.valueToTree(this.getAutoImportPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (this.autoExportPolicy != null ? !this.autoExportPolicy.equals(that.autoExportPolicy) : that.autoExportPolicy != null) return false;
                return this.autoImportPolicy != null ? this.autoImportPolicy.equals(that.autoImportPolicy) : that.autoImportPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoExportPolicy != null ? this.autoExportPolicy.hashCode() : 0;
                result = 31 * result + (this.autoImportPolicy != null ? this.autoImportPolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps.Builder();
        }

        /**
         * The path to the Amazon S3 data repository that will be linked to the file system.
         * <p>
         * The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code> . This path specifies where in the S3 data repository files will be imported from or exported to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-datarepositorypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-datarepositorypath</a>
         * @param dataRepositoryPath The path to the Amazon S3 data repository that will be linked to the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataRepositoryPath(final java.lang.String dataRepositoryPath) {
            this.props.dataRepositoryPath(dataRepositoryPath);
            return this;
        }

        /**
         * The ID of the file system on which the data repository association is configured.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-filesystemid</a>
         * @param fileSystemId The ID of the file system on which the data repository association is configured. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(final java.lang.String fileSystemId) {
            this.props.fileSystemId(fileSystemId);
            return this;
        }

        /**
         * A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as <code>/ns1/</code> ) or subdirectory (such as <code>/ns1/subdir/</code> ) that will be mapped 1-1 with <code>DataRepositoryPath</code> .
         * <p>
         * The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code> , then you cannot link another data repository with file system path <code>/ns1/ns2</code> .
         * <p>
         * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         * <p>
         * <blockquote>
         * <p>
         * If you specify only a forward slash ( <code>/</code> ) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-filesystempath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-filesystempath</a>
         * @param fileSystemPath A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as <code>/ns1/</code> ) or subdirectory (such as <code>/ns1/subdir/</code> ) that will be mapped 1-1 with <code>DataRepositoryPath</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPath(final java.lang.String fileSystemPath) {
            this.props.fileSystemPath(fileSystemPath);
            return this;
        }

        /**
         * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created.
         * <p>
         * The task runs if this flag is set to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-batchimportmetadataoncreate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-batchimportmetadataoncreate</a>
         * @param batchImportMetaDataOnCreate A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(final java.lang.Boolean batchImportMetaDataOnCreate) {
            this.props.batchImportMetaDataOnCreate(batchImportMetaDataOnCreate);
            return this;
        }
        /**
         * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created.
         * <p>
         * The task runs if this flag is set to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-batchimportmetadataoncreate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-batchimportmetadataoncreate</a>
         * @param batchImportMetaDataOnCreate A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(final software.amazon.awscdk.IResolvable batchImportMetaDataOnCreate) {
            this.props.batchImportMetaDataOnCreate(batchImportMetaDataOnCreate);
            return this;
        }

        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
         * <p>
         * The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-importedfilechunksize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-importedfilechunksize</a>
         * @param importedFileChunkSize For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importedFileChunkSize(final java.lang.Number importedFileChunkSize) {
            this.props.importedFileChunkSize(importedFileChunkSize);
            return this;
        }

        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
         * <p>
         * The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-s3</a>
         * @param s3 The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(final software.amazon.awscdk.IResolvable s3) {
            this.props.s3(s3);
            return this;
        }
        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association.
         * <p>
         * The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-s3</a>
         * @param s3 The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(final software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property s3) {
            this.props.s3(s3);
            return this;
        }

        /**
         * A list of <code>Tag</code> values, with a maximum of 50 elements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html#cfn-fsx-datarepositoryassociation-tags</a>
         * @param tags A list of <code>Tag</code> values, with a maximum of 50 elements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation build() {
            return new software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
