package software.amazon.awscdk.services.gamelift;

/**
 * A reference to a Alias resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * AliasReference aliasReference = AliasReference.builder()
 *         .aliasArn("aliasArn")
 *         .aliasId("aliasId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.657Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.AliasReference")
@software.amazon.jsii.Jsii.Proxy(AliasReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Alias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAliasArn();

    /**
     * The AliasId of the Alias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAliasId();

    /**
     * @return a {@link Builder} of {@link AliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AliasReference> {
        java.lang.String aliasArn;
        java.lang.String aliasId;

        /**
         * Sets the value of {@link AliasReference#getAliasArn}
         * @param aliasArn The ARN of the Alias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasArn(java.lang.String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        /**
         * Sets the value of {@link AliasReference#getAliasId}
         * @param aliasId The AliasId of the Alias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasId(java.lang.String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AliasReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasReference {
        private final java.lang.String aliasArn;
        private final java.lang.String aliasId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliasArn = software.amazon.jsii.Kernel.get(this, "aliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aliasId = software.amazon.jsii.Kernel.get(this, "aliasId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliasArn = java.util.Objects.requireNonNull(builder.aliasArn, "aliasArn is required");
            this.aliasId = java.util.Objects.requireNonNull(builder.aliasId, "aliasId is required");
        }

        @Override
        public final java.lang.String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final java.lang.String getAliasId() {
            return this.aliasId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aliasArn", om.valueToTree(this.getAliasArn()));
            data.set("aliasId", om.valueToTree(this.getAliasId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.AliasReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasReference.Jsii$Proxy that = (AliasReference.Jsii$Proxy) o;

            if (!aliasArn.equals(that.aliasArn)) return false;
            return this.aliasId.equals(that.aliasId);
        }

        @Override
        public final int hashCode() {
            int result = this.aliasArn.hashCode();
            result = 31 * result + (this.aliasId.hashCode());
            return result;
        }
    }
}
