package software.amazon.awscdk.services.gamelift;

/**
 * A reference to a ContainerGroupDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * ContainerGroupDefinitionReference containerGroupDefinitionReference = ContainerGroupDefinitionReference.builder()
 *         .containerGroupDefinitionArn("containerGroupDefinitionArn")
 *         .containerGroupDefinitionName("containerGroupDefinitionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.741Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.ContainerGroupDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(ContainerGroupDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerGroupDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ContainerGroupDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerGroupDefinitionArn();

    /**
     * The Name of the ContainerGroupDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerGroupDefinitionName();

    /**
     * @return a {@link Builder} of {@link ContainerGroupDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerGroupDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerGroupDefinitionReference> {
        java.lang.String containerGroupDefinitionArn;
        java.lang.String containerGroupDefinitionName;

        /**
         * Sets the value of {@link ContainerGroupDefinitionReference#getContainerGroupDefinitionArn}
         * @param containerGroupDefinitionArn The ARN of the ContainerGroupDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerGroupDefinitionArn(java.lang.String containerGroupDefinitionArn) {
            this.containerGroupDefinitionArn = containerGroupDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link ContainerGroupDefinitionReference#getContainerGroupDefinitionName}
         * @param containerGroupDefinitionName The Name of the ContainerGroupDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerGroupDefinitionName(java.lang.String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerGroupDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerGroupDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerGroupDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerGroupDefinitionReference {
        private final java.lang.String containerGroupDefinitionArn;
        private final java.lang.String containerGroupDefinitionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerGroupDefinitionArn = software.amazon.jsii.Kernel.get(this, "containerGroupDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerGroupDefinitionName = software.amazon.jsii.Kernel.get(this, "containerGroupDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerGroupDefinitionArn = java.util.Objects.requireNonNull(builder.containerGroupDefinitionArn, "containerGroupDefinitionArn is required");
            this.containerGroupDefinitionName = java.util.Objects.requireNonNull(builder.containerGroupDefinitionName, "containerGroupDefinitionName is required");
        }

        @Override
        public final java.lang.String getContainerGroupDefinitionArn() {
            return this.containerGroupDefinitionArn;
        }

        @Override
        public final java.lang.String getContainerGroupDefinitionName() {
            return this.containerGroupDefinitionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerGroupDefinitionArn", om.valueToTree(this.getContainerGroupDefinitionArn()));
            data.set("containerGroupDefinitionName", om.valueToTree(this.getContainerGroupDefinitionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.ContainerGroupDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerGroupDefinitionReference.Jsii$Proxy that = (ContainerGroupDefinitionReference.Jsii$Proxy) o;

            if (!containerGroupDefinitionArn.equals(that.containerGroupDefinitionArn)) return false;
            return this.containerGroupDefinitionName.equals(that.containerGroupDefinitionName);
        }

        @Override
        public final int hashCode() {
            int result = this.containerGroupDefinitionArn.hashCode();
            result = 31 * result + (this.containerGroupDefinitionName.hashCode());
            return result;
        }
    }
}
