package software.amazon.awscdk.services.gamelift;

/**
 * A reference to a Fleet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * FleetReference fleetReference = FleetReference.builder()
 *         .fleetArn("fleetArn")
 *         .fleetId("fleetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.FleetReference")
@software.amazon.jsii.Jsii.Proxy(FleetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FleetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Fleet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFleetArn();

    /**
     * The FleetId of the Fleet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFleetId();

    /**
     * @return a {@link Builder} of {@link FleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FleetReference> {
        java.lang.String fleetArn;
        java.lang.String fleetId;

        /**
         * Sets the value of {@link FleetReference#getFleetArn}
         * @param fleetArn The ARN of the Fleet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetArn(java.lang.String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        /**
         * Sets the value of {@link FleetReference#getFleetId}
         * @param fleetId The FleetId of the Fleet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetId(java.lang.String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FleetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FleetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetReference {
        private final java.lang.String fleetArn;
        private final java.lang.String fleetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fleetArn = software.amazon.jsii.Kernel.get(this, "fleetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fleetId = software.amazon.jsii.Kernel.get(this, "fleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fleetArn = java.util.Objects.requireNonNull(builder.fleetArn, "fleetArn is required");
            this.fleetId = java.util.Objects.requireNonNull(builder.fleetId, "fleetId is required");
        }

        @Override
        public final java.lang.String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final java.lang.String getFleetId() {
            return this.fleetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fleetArn", om.valueToTree(this.getFleetArn()));
            data.set("fleetId", om.valueToTree(this.getFleetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.FleetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FleetReference.Jsii$Proxy that = (FleetReference.Jsii$Proxy) o;

            if (!fleetArn.equals(that.fleetArn)) return false;
            return this.fleetId.equals(that.fleetId);
        }

        @Override
        public final int hashCode() {
            int result = this.fleetArn.hashCode();
            result = 31 * result + (this.fleetId.hashCode());
            return result;
        }
    }
}
