package software.amazon.awscdk.services.gamelift;

/**
 * A reference to a MatchmakingConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * MatchmakingConfigurationReference matchmakingConfigurationReference = MatchmakingConfigurationReference.builder()
 *         .matchmakingConfigurationArn("matchmakingConfigurationArn")
 *         .matchmakingConfigurationName("matchmakingConfigurationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.757Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.MatchmakingConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(MatchmakingConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MatchmakingConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MatchmakingConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMatchmakingConfigurationArn();

    /**
     * The Name of the MatchmakingConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMatchmakingConfigurationName();

    /**
     * @return a {@link Builder} of {@link MatchmakingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MatchmakingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MatchmakingConfigurationReference> {
        java.lang.String matchmakingConfigurationArn;
        java.lang.String matchmakingConfigurationName;

        /**
         * Sets the value of {@link MatchmakingConfigurationReference#getMatchmakingConfigurationArn}
         * @param matchmakingConfigurationArn The ARN of the MatchmakingConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchmakingConfigurationArn(java.lang.String matchmakingConfigurationArn) {
            this.matchmakingConfigurationArn = matchmakingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link MatchmakingConfigurationReference#getMatchmakingConfigurationName}
         * @param matchmakingConfigurationName The Name of the MatchmakingConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchmakingConfigurationName(java.lang.String matchmakingConfigurationName) {
            this.matchmakingConfigurationName = matchmakingConfigurationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MatchmakingConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MatchmakingConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MatchmakingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchmakingConfigurationReference {
        private final java.lang.String matchmakingConfigurationArn;
        private final java.lang.String matchmakingConfigurationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.matchmakingConfigurationArn = software.amazon.jsii.Kernel.get(this, "matchmakingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matchmakingConfigurationName = software.amazon.jsii.Kernel.get(this, "matchmakingConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.matchmakingConfigurationArn = java.util.Objects.requireNonNull(builder.matchmakingConfigurationArn, "matchmakingConfigurationArn is required");
            this.matchmakingConfigurationName = java.util.Objects.requireNonNull(builder.matchmakingConfigurationName, "matchmakingConfigurationName is required");
        }

        @Override
        public final java.lang.String getMatchmakingConfigurationArn() {
            return this.matchmakingConfigurationArn;
        }

        @Override
        public final java.lang.String getMatchmakingConfigurationName() {
            return this.matchmakingConfigurationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("matchmakingConfigurationArn", om.valueToTree(this.getMatchmakingConfigurationArn()));
            data.set("matchmakingConfigurationName", om.valueToTree(this.getMatchmakingConfigurationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.MatchmakingConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MatchmakingConfigurationReference.Jsii$Proxy that = (MatchmakingConfigurationReference.Jsii$Proxy) o;

            if (!matchmakingConfigurationArn.equals(that.matchmakingConfigurationArn)) return false;
            return this.matchmakingConfigurationName.equals(that.matchmakingConfigurationName);
        }

        @Override
        public final int hashCode() {
            int result = this.matchmakingConfigurationArn.hashCode();
            result = 31 * result + (this.matchmakingConfigurationName.hashCode());
            return result;
        }
    }
}
