package software.amazon.awscdk.services.glue;

/**
 * A reference to a DataCatalogEncryptionSettings resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * DataCatalogEncryptionSettingsReference dataCatalogEncryptionSettingsReference = DataCatalogEncryptionSettingsReference.builder()
 *         .dataCatalogEncryptionSettingsId("dataCatalogEncryptionSettingsId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:06.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.DataCatalogEncryptionSettingsReference")
@software.amazon.jsii.Jsii.Proxy(DataCatalogEncryptionSettingsReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataCatalogEncryptionSettingsReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the DataCatalogEncryptionSettings resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataCatalogEncryptionSettingsId();

    /**
     * @return a {@link Builder} of {@link DataCatalogEncryptionSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataCatalogEncryptionSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataCatalogEncryptionSettingsReference> {
        java.lang.String dataCatalogEncryptionSettingsId;

        /**
         * Sets the value of {@link DataCatalogEncryptionSettingsReference#getDataCatalogEncryptionSettingsId}
         * @param dataCatalogEncryptionSettingsId The Id of the DataCatalogEncryptionSettings resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogEncryptionSettingsId(java.lang.String dataCatalogEncryptionSettingsId) {
            this.dataCatalogEncryptionSettingsId = dataCatalogEncryptionSettingsId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataCatalogEncryptionSettingsReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataCatalogEncryptionSettingsReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataCatalogEncryptionSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogEncryptionSettingsReference {
        private final java.lang.String dataCatalogEncryptionSettingsId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataCatalogEncryptionSettingsId = software.amazon.jsii.Kernel.get(this, "dataCatalogEncryptionSettingsId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataCatalogEncryptionSettingsId = java.util.Objects.requireNonNull(builder.dataCatalogEncryptionSettingsId, "dataCatalogEncryptionSettingsId is required");
        }

        @Override
        public final java.lang.String getDataCatalogEncryptionSettingsId() {
            return this.dataCatalogEncryptionSettingsId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataCatalogEncryptionSettingsId", om.valueToTree(this.getDataCatalogEncryptionSettingsId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.DataCatalogEncryptionSettingsReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataCatalogEncryptionSettingsReference.Jsii$Proxy that = (DataCatalogEncryptionSettingsReference.Jsii$Proxy) o;

            return this.dataCatalogEncryptionSettingsId.equals(that.dataCatalogEncryptionSettingsId);
        }

        @Override
        public final int hashCode() {
            int result = this.dataCatalogEncryptionSettingsId.hashCode();
            return result;
        }
    }
}
