package software.amazon.awscdk.services.greengrass;

/**
 * A reference to a CoreDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CoreDefinitionReference coreDefinitionReference = CoreDefinitionReference.builder()
 *         .coreDefinitionArn("coreDefinitionArn")
 *         .coreDefinitionId("coreDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.071Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CoreDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(CoreDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CoreDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CoreDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreDefinitionArn();

    /**
     * The Id of the CoreDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreDefinitionId();

    /**
     * @return a {@link Builder} of {@link CoreDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CoreDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CoreDefinitionReference> {
        java.lang.String coreDefinitionArn;
        java.lang.String coreDefinitionId;

        /**
         * Sets the value of {@link CoreDefinitionReference#getCoreDefinitionArn}
         * @param coreDefinitionArn The ARN of the CoreDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDefinitionArn(java.lang.String coreDefinitionArn) {
            this.coreDefinitionArn = coreDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link CoreDefinitionReference#getCoreDefinitionId}
         * @param coreDefinitionId The Id of the CoreDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDefinitionId(java.lang.String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CoreDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CoreDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CoreDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoreDefinitionReference {
        private final java.lang.String coreDefinitionArn;
        private final java.lang.String coreDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreDefinitionArn = software.amazon.jsii.Kernel.get(this, "coreDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.coreDefinitionId = software.amazon.jsii.Kernel.get(this, "coreDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreDefinitionArn = java.util.Objects.requireNonNull(builder.coreDefinitionArn, "coreDefinitionArn is required");
            this.coreDefinitionId = java.util.Objects.requireNonNull(builder.coreDefinitionId, "coreDefinitionId is required");
        }

        @Override
        public final java.lang.String getCoreDefinitionArn() {
            return this.coreDefinitionArn;
        }

        @Override
        public final java.lang.String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreDefinitionArn", om.valueToTree(this.getCoreDefinitionArn()));
            data.set("coreDefinitionId", om.valueToTree(this.getCoreDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CoreDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CoreDefinitionReference.Jsii$Proxy that = (CoreDefinitionReference.Jsii$Proxy) o;

            if (!coreDefinitionArn.equals(that.coreDefinitionArn)) return false;
            return this.coreDefinitionId.equals(that.coreDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.coreDefinitionArn.hashCode();
            result = 31 * result + (this.coreDefinitionId.hashCode());
            return result;
        }
    }
}
