package software.amazon.awscdk.services.greengrass;

/**
 * A reference to a DeviceDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * DeviceDefinitionReference deviceDefinitionReference = DeviceDefinitionReference.builder()
 *         .deviceDefinitionArn("deviceDefinitionArn")
 *         .deviceDefinitionId("deviceDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.071Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.DeviceDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(DeviceDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeviceDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DeviceDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceDefinitionArn();

    /**
     * The Id of the DeviceDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceDefinitionId();

    /**
     * @return a {@link Builder} of {@link DeviceDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeviceDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeviceDefinitionReference> {
        java.lang.String deviceDefinitionArn;
        java.lang.String deviceDefinitionId;

        /**
         * Sets the value of {@link DeviceDefinitionReference#getDeviceDefinitionArn}
         * @param deviceDefinitionArn The ARN of the DeviceDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionArn(java.lang.String deviceDefinitionArn) {
            this.deviceDefinitionArn = deviceDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link DeviceDefinitionReference#getDeviceDefinitionId}
         * @param deviceDefinitionId The Id of the DeviceDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionId(java.lang.String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeviceDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeviceDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeviceDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceDefinitionReference {
        private final java.lang.String deviceDefinitionArn;
        private final java.lang.String deviceDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceDefinitionArn = software.amazon.jsii.Kernel.get(this, "deviceDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceDefinitionId = software.amazon.jsii.Kernel.get(this, "deviceDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceDefinitionArn = java.util.Objects.requireNonNull(builder.deviceDefinitionArn, "deviceDefinitionArn is required");
            this.deviceDefinitionId = java.util.Objects.requireNonNull(builder.deviceDefinitionId, "deviceDefinitionId is required");
        }

        @Override
        public final java.lang.String getDeviceDefinitionArn() {
            return this.deviceDefinitionArn;
        }

        @Override
        public final java.lang.String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deviceDefinitionArn", om.valueToTree(this.getDeviceDefinitionArn()));
            data.set("deviceDefinitionId", om.valueToTree(this.getDeviceDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.DeviceDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeviceDefinitionReference.Jsii$Proxy that = (DeviceDefinitionReference.Jsii$Proxy) o;

            if (!deviceDefinitionArn.equals(that.deviceDefinitionArn)) return false;
            return this.deviceDefinitionId.equals(that.deviceDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.deviceDefinitionArn.hashCode();
            result = 31 * result + (this.deviceDefinitionId.hashCode());
            return result;
        }
    }
}
