package software.amazon.awscdk.services.greengrass;

/**
 * A reference to a FunctionDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * FunctionDefinitionReference functionDefinitionReference = FunctionDefinitionReference.builder()
 *         .functionDefinitionArn("functionDefinitionArn")
 *         .functionDefinitionId("functionDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.072Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.FunctionDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(FunctionDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the FunctionDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionDefinitionArn();

    /**
     * The Id of the FunctionDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionDefinitionId();

    /**
     * @return a {@link Builder} of {@link FunctionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionDefinitionReference> {
        java.lang.String functionDefinitionArn;
        java.lang.String functionDefinitionId;

        /**
         * Sets the value of {@link FunctionDefinitionReference#getFunctionDefinitionArn}
         * @param functionDefinitionArn The ARN of the FunctionDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionArn(java.lang.String functionDefinitionArn) {
            this.functionDefinitionArn = functionDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link FunctionDefinitionReference#getFunctionDefinitionId}
         * @param functionDefinitionId The Id of the FunctionDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionId(java.lang.String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionDefinitionReference {
        private final java.lang.String functionDefinitionArn;
        private final java.lang.String functionDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionDefinitionArn = software.amazon.jsii.Kernel.get(this, "functionDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionDefinitionId = software.amazon.jsii.Kernel.get(this, "functionDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionDefinitionArn = java.util.Objects.requireNonNull(builder.functionDefinitionArn, "functionDefinitionArn is required");
            this.functionDefinitionId = java.util.Objects.requireNonNull(builder.functionDefinitionId, "functionDefinitionId is required");
        }

        @Override
        public final java.lang.String getFunctionDefinitionArn() {
            return this.functionDefinitionArn;
        }

        @Override
        public final java.lang.String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionDefinitionArn", om.valueToTree(this.getFunctionDefinitionArn()));
            data.set("functionDefinitionId", om.valueToTree(this.getFunctionDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.FunctionDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionDefinitionReference.Jsii$Proxy that = (FunctionDefinitionReference.Jsii$Proxy) o;

            if (!functionDefinitionArn.equals(that.functionDefinitionArn)) return false;
            return this.functionDefinitionId.equals(that.functionDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.functionDefinitionArn.hashCode();
            result = 31 * result + (this.functionDefinitionId.hashCode());
            return result;
        }
    }
}
