package software.amazon.awscdk.services.groundstation;

/**
 * A reference to a DataflowEndpointGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.groundstation.*;
 * DataflowEndpointGroupReference dataflowEndpointGroupReference = DataflowEndpointGroupReference.builder()
 *         .dataflowEndpointGroupArn("dataflowEndpointGroupArn")
 *         .dataflowEndpointGroupId("dataflowEndpointGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.133Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_groundstation.DataflowEndpointGroupReference")
@software.amazon.jsii.Jsii.Proxy(DataflowEndpointGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataflowEndpointGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DataflowEndpointGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataflowEndpointGroupArn();

    /**
     * The Id of the DataflowEndpointGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataflowEndpointGroupId();

    /**
     * @return a {@link Builder} of {@link DataflowEndpointGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataflowEndpointGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataflowEndpointGroupReference> {
        java.lang.String dataflowEndpointGroupArn;
        java.lang.String dataflowEndpointGroupId;

        /**
         * Sets the value of {@link DataflowEndpointGroupReference#getDataflowEndpointGroupArn}
         * @param dataflowEndpointGroupArn The ARN of the DataflowEndpointGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataflowEndpointGroupArn(java.lang.String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link DataflowEndpointGroupReference#getDataflowEndpointGroupId}
         * @param dataflowEndpointGroupId The Id of the DataflowEndpointGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataflowEndpointGroupId(java.lang.String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataflowEndpointGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataflowEndpointGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataflowEndpointGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataflowEndpointGroupReference {
        private final java.lang.String dataflowEndpointGroupArn;
        private final java.lang.String dataflowEndpointGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataflowEndpointGroupArn = software.amazon.jsii.Kernel.get(this, "dataflowEndpointGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataflowEndpointGroupId = software.amazon.jsii.Kernel.get(this, "dataflowEndpointGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataflowEndpointGroupArn = java.util.Objects.requireNonNull(builder.dataflowEndpointGroupArn, "dataflowEndpointGroupArn is required");
            this.dataflowEndpointGroupId = java.util.Objects.requireNonNull(builder.dataflowEndpointGroupId, "dataflowEndpointGroupId is required");
        }

        @Override
        public final java.lang.String getDataflowEndpointGroupArn() {
            return this.dataflowEndpointGroupArn;
        }

        @Override
        public final java.lang.String getDataflowEndpointGroupId() {
            return this.dataflowEndpointGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataflowEndpointGroupArn", om.valueToTree(this.getDataflowEndpointGroupArn()));
            data.set("dataflowEndpointGroupId", om.valueToTree(this.getDataflowEndpointGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_groundstation.DataflowEndpointGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataflowEndpointGroupReference.Jsii$Proxy that = (DataflowEndpointGroupReference.Jsii$Proxy) o;

            if (!dataflowEndpointGroupArn.equals(that.dataflowEndpointGroupArn)) return false;
            return this.dataflowEndpointGroupId.equals(that.dataflowEndpointGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.dataflowEndpointGroupArn.hashCode();
            result = 31 * result + (this.dataflowEndpointGroupId.hashCode());
            return result;
        }
    }
}
