package software.amazon.awscdk.services.guardduty;

/**
 * A reference to a MalwareProtectionPlan resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * MalwareProtectionPlanReference malwareProtectionPlanReference = MalwareProtectionPlanReference.builder()
 *         .malwareProtectionPlanArn("malwareProtectionPlanArn")
 *         .malwareProtectionPlanId("malwareProtectionPlanId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.195Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.MalwareProtectionPlanReference")
@software.amazon.jsii.Jsii.Proxy(MalwareProtectionPlanReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MalwareProtectionPlanReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MalwareProtectionPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMalwareProtectionPlanArn();

    /**
     * The MalwareProtectionPlanId of the MalwareProtectionPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMalwareProtectionPlanId();

    /**
     * @return a {@link Builder} of {@link MalwareProtectionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MalwareProtectionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MalwareProtectionPlanReference> {
        java.lang.String malwareProtectionPlanArn;
        java.lang.String malwareProtectionPlanId;

        /**
         * Sets the value of {@link MalwareProtectionPlanReference#getMalwareProtectionPlanArn}
         * @param malwareProtectionPlanArn The ARN of the MalwareProtectionPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder malwareProtectionPlanArn(java.lang.String malwareProtectionPlanArn) {
            this.malwareProtectionPlanArn = malwareProtectionPlanArn;
            return this;
        }

        /**
         * Sets the value of {@link MalwareProtectionPlanReference#getMalwareProtectionPlanId}
         * @param malwareProtectionPlanId The MalwareProtectionPlanId of the MalwareProtectionPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder malwareProtectionPlanId(java.lang.String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MalwareProtectionPlanReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MalwareProtectionPlanReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MalwareProtectionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MalwareProtectionPlanReference {
        private final java.lang.String malwareProtectionPlanArn;
        private final java.lang.String malwareProtectionPlanId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.malwareProtectionPlanArn = software.amazon.jsii.Kernel.get(this, "malwareProtectionPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.malwareProtectionPlanId = software.amazon.jsii.Kernel.get(this, "malwareProtectionPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.malwareProtectionPlanArn = java.util.Objects.requireNonNull(builder.malwareProtectionPlanArn, "malwareProtectionPlanArn is required");
            this.malwareProtectionPlanId = java.util.Objects.requireNonNull(builder.malwareProtectionPlanId, "malwareProtectionPlanId is required");
        }

        @Override
        public final java.lang.String getMalwareProtectionPlanArn() {
            return this.malwareProtectionPlanArn;
        }

        @Override
        public final java.lang.String getMalwareProtectionPlanId() {
            return this.malwareProtectionPlanId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("malwareProtectionPlanArn", om.valueToTree(this.getMalwareProtectionPlanArn()));
            data.set("malwareProtectionPlanId", om.valueToTree(this.getMalwareProtectionPlanId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.MalwareProtectionPlanReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MalwareProtectionPlanReference.Jsii$Proxy that = (MalwareProtectionPlanReference.Jsii$Proxy) o;

            if (!malwareProtectionPlanArn.equals(that.malwareProtectionPlanArn)) return false;
            return this.malwareProtectionPlanId.equals(that.malwareProtectionPlanId);
        }

        @Override
        public final int hashCode() {
            int result = this.malwareProtectionPlanArn.hashCode();
            result = 31 * result + (this.malwareProtectionPlanId.hashCode());
            return result;
        }
    }
}
