package software.amazon.awscdk.services.guardduty;

/**
 * A reference to a ThreatIntelSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * ThreatIntelSetReference threatIntelSetReference = ThreatIntelSetReference.builder()
 *         .detectorId("detectorId")
 *         .threatIntelSetId("threatIntelSetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.196Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.ThreatIntelSetReference")
@software.amazon.jsii.Jsii.Proxy(ThreatIntelSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThreatIntelSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DetectorId of the ThreatIntelSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * The Id of the ThreatIntelSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThreatIntelSetId();

    /**
     * @return a {@link Builder} of {@link ThreatIntelSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThreatIntelSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThreatIntelSetReference> {
        java.lang.String detectorId;
        java.lang.String threatIntelSetId;

        /**
         * Sets the value of {@link ThreatIntelSetReference#getDetectorId}
         * @param detectorId The DetectorId of the ThreatIntelSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link ThreatIntelSetReference#getThreatIntelSetId}
         * @param threatIntelSetId The Id of the ThreatIntelSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threatIntelSetId(java.lang.String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThreatIntelSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThreatIntelSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThreatIntelSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThreatIntelSetReference {
        private final java.lang.String detectorId;
        private final java.lang.String threatIntelSetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.threatIntelSetId = software.amazon.jsii.Kernel.get(this, "threatIntelSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.threatIntelSetId = java.util.Objects.requireNonNull(builder.threatIntelSetId, "threatIntelSetId is required");
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.String getThreatIntelSetId() {
            return this.threatIntelSetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("threatIntelSetId", om.valueToTree(this.getThreatIntelSetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.ThreatIntelSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThreatIntelSetReference.Jsii$Proxy that = (ThreatIntelSetReference.Jsii$Proxy) o;

            if (!detectorId.equals(that.detectorId)) return false;
            return this.threatIntelSetId.equals(that.threatIntelSetId);
        }

        @Override
        public final int hashCode() {
            int result = this.detectorId.hashCode();
            result = 31 * result + (this.threatIntelSetId.hashCode());
            return result;
        }
    }
}
