package software.amazon.awscdk.services.healthlake;

/**
 * A reference to a FHIRDatastore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.healthlake.*;
 * FHIRDatastoreReference fHIRDatastoreReference = FHIRDatastoreReference.builder()
 *         .datastoreId("datastoreId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.204Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.FHIRDatastoreReference")
@software.amazon.jsii.Jsii.Proxy(FHIRDatastoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FHIRDatastoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DatastoreId of the FHIRDatastore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatastoreId();

    /**
     * @return a {@link Builder} of {@link FHIRDatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FHIRDatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FHIRDatastoreReference> {
        java.lang.String datastoreId;

        /**
         * Sets the value of {@link FHIRDatastoreReference#getDatastoreId}
         * @param datastoreId The DatastoreId of the FHIRDatastore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreId(java.lang.String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FHIRDatastoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FHIRDatastoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FHIRDatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FHIRDatastoreReference {
        private final java.lang.String datastoreId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datastoreId = software.amazon.jsii.Kernel.get(this, "datastoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datastoreId = java.util.Objects.requireNonNull(builder.datastoreId, "datastoreId is required");
        }

        @Override
        public final java.lang.String getDatastoreId() {
            return this.datastoreId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datastoreId", om.valueToTree(this.getDatastoreId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.FHIRDatastoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FHIRDatastoreReference.Jsii$Proxy that = (FHIRDatastoreReference.Jsii$Proxy) o;

            return this.datastoreId.equals(that.datastoreId);
        }

        @Override
        public final int hashCode() {
            int result = this.datastoreId.hashCode();
            return result;
        }
    }
}
