package software.amazon.awscdk.services.iot;

/**
 * A reference to a CertificateProvider resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CertificateProviderReference certificateProviderReference = CertificateProviderReference.builder()
 *         .certificateProviderArn("certificateProviderArn")
 *         .certificateProviderName("certificateProviderName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.522Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CertificateProviderReference")
@software.amazon.jsii.Jsii.Proxy(CertificateProviderReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificateProviderReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CertificateProvider resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateProviderArn();

    /**
     * The CertificateProviderName of the CertificateProvider resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateProviderName();

    /**
     * @return a {@link Builder} of {@link CertificateProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CertificateProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CertificateProviderReference> {
        java.lang.String certificateProviderArn;
        java.lang.String certificateProviderName;

        /**
         * Sets the value of {@link CertificateProviderReference#getCertificateProviderArn}
         * @param certificateProviderArn The ARN of the CertificateProvider resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateProviderArn(java.lang.String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProviderReference#getCertificateProviderName}
         * @param certificateProviderName The CertificateProviderName of the CertificateProvider resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateProviderName(java.lang.String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProviderReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CertificateProviderReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CertificateProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProviderReference {
        private final java.lang.String certificateProviderArn;
        private final java.lang.String certificateProviderName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateProviderArn = software.amazon.jsii.Kernel.get(this, "certificateProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateProviderName = software.amazon.jsii.Kernel.get(this, "certificateProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateProviderArn = java.util.Objects.requireNonNull(builder.certificateProviderArn, "certificateProviderArn is required");
            this.certificateProviderName = java.util.Objects.requireNonNull(builder.certificateProviderName, "certificateProviderName is required");
        }

        @Override
        public final java.lang.String getCertificateProviderArn() {
            return this.certificateProviderArn;
        }

        @Override
        public final java.lang.String getCertificateProviderName() {
            return this.certificateProviderName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificateProviderArn", om.valueToTree(this.getCertificateProviderArn()));
            data.set("certificateProviderName", om.valueToTree(this.getCertificateProviderName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CertificateProviderReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CertificateProviderReference.Jsii$Proxy that = (CertificateProviderReference.Jsii$Proxy) o;

            if (!certificateProviderArn.equals(that.certificateProviderArn)) return false;
            return this.certificateProviderName.equals(that.certificateProviderName);
        }

        @Override
        public final int hashCode() {
            int result = this.certificateProviderArn.hashCode();
            result = 31 * result + (this.certificateProviderName.hashCode());
            return result;
        }
    }
}
