package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnTopicRuleDestination</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnTopicRuleDestinationProps cfnTopicRuleDestinationProps = CfnTopicRuleDestinationProps.builder()
 *         .httpUrlProperties(HttpUrlDestinationSummaryProperty.builder()
 *                 .confirmationUrl("confirmationUrl")
 *                 .build())
 *         .status("status")
 *         .vpcProperties(VpcDestinationPropertiesProperty.builder()
 *                 .roleArn("roleArn")
 *                 .securityGroups(List.of("securityGroups"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.682Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRuleDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTopicRuleDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTopicRuleDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Properties of the HTTP URL.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnTopicRuleDestination.HttpUrlDestinationSummaryProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-httpurlproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-httpurlproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpUrlProperties() {
        return null;
    }

    /**
     * <ul><li><strong>IN_PROGRESS</strong> - A topic rule destination was created but has not been confirmed.</li></ul>
     * <p>
     * You can set status to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code> . Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.
     * <p>
     * <ul>
     * <li><strong>ENABLED</strong> - Confirmation was completed, and traffic to this destination is allowed. You can set status to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code> .</li>
     * <li><strong>DISABLED</strong> - Confirmation was completed, and traffic to this destination is not allowed. You can set status to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code> .</li>
     * <li><strong>ERROR</strong> - Confirmation could not be completed; for example, if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set status to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code> . Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * Properties of the virtual private cloud (VPC) connection.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnTopicRuleDestination.VpcDestinationPropertiesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-vpcproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-vpcproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTopicRuleDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTopicRuleDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTopicRuleDestinationProps> {
        java.lang.Object httpUrlProperties;
        java.lang.String status;
        java.lang.Object vpcProperties;

        /**
         * Sets the value of {@link CfnTopicRuleDestinationProps#getHttpUrlProperties}
         * @param httpUrlProperties Properties of the HTTP URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpUrlProperties(software.amazon.awscdk.IResolvable httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleDestinationProps#getHttpUrlProperties}
         * @param httpUrlProperties Properties of the HTTP URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpUrlProperties(software.amazon.awscdk.services.iot.CfnTopicRuleDestination.HttpUrlDestinationSummaryProperty httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleDestinationProps#getStatus}
         * @param status <ul><li><strong>IN_PROGRESS</strong> - A topic rule destination was created but has not been confirmed.</li></ul>
         *               You can set status to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code> . Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.
         *               <p>
         *               <ul>
         *               <li><strong>ENABLED</strong> - Confirmation was completed, and traffic to this destination is allowed. You can set status to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code> .</li>
         *               <li><strong>DISABLED</strong> - Confirmation was completed, and traffic to this destination is not allowed. You can set status to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code> .</li>
         *               <li><strong>ERROR</strong> - Confirmation could not be completed; for example, if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set status to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code> . Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleDestinationProps#getVpcProperties}
         * @param vpcProperties Properties of the virtual private cloud (VPC) connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcProperties(software.amazon.awscdk.IResolvable vpcProperties) {
            this.vpcProperties = vpcProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicRuleDestinationProps#getVpcProperties}
         * @param vpcProperties Properties of the virtual private cloud (VPC) connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcProperties(software.amazon.awscdk.services.iot.CfnTopicRuleDestination.VpcDestinationPropertiesProperty vpcProperties) {
            this.vpcProperties = vpcProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTopicRuleDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTopicRuleDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTopicRuleDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTopicRuleDestinationProps {
        private final java.lang.Object httpUrlProperties;
        private final java.lang.String status;
        private final java.lang.Object vpcProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpUrlProperties = software.amazon.jsii.Kernel.get(this, "httpUrlProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcProperties = software.amazon.jsii.Kernel.get(this, "vpcProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpUrlProperties = builder.httpUrlProperties;
            this.status = builder.status;
            this.vpcProperties = builder.vpcProperties;
        }

        @Override
        public final java.lang.Object getHttpUrlProperties() {
            return this.httpUrlProperties;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.Object getVpcProperties() {
            return this.vpcProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHttpUrlProperties() != null) {
                data.set("httpUrlProperties", om.valueToTree(this.getHttpUrlProperties()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getVpcProperties() != null) {
                data.set("vpcProperties", om.valueToTree(this.getVpcProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRuleDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTopicRuleDestinationProps.Jsii$Proxy that = (CfnTopicRuleDestinationProps.Jsii$Proxy) o;

            if (this.httpUrlProperties != null ? !this.httpUrlProperties.equals(that.httpUrlProperties) : that.httpUrlProperties != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.vpcProperties != null ? this.vpcProperties.equals(that.vpcProperties) : that.vpcProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpUrlProperties != null ? this.httpUrlProperties.hashCode() : 0;
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.vpcProperties != null ? this.vpcProperties.hashCode() : 0);
            return result;
        }
    }
}
