package software.amazon.awscdk.services.iot;

/**
 * A reference to a Command resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CommandReference commandReference = CommandReference.builder()
 *         .commandArn("commandArn")
 *         .commandId("commandId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.686Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CommandReference")
@software.amazon.jsii.Jsii.Proxy(CommandReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommandReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Command resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommandArn();

    /**
     * The CommandId of the Command resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommandId();

    /**
     * @return a {@link Builder} of {@link CommandReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommandReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommandReference> {
        java.lang.String commandArn;
        java.lang.String commandId;

        /**
         * Sets the value of {@link CommandReference#getCommandArn}
         * @param commandArn The ARN of the Command resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commandArn(java.lang.String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        /**
         * Sets the value of {@link CommandReference#getCommandId}
         * @param commandId The CommandId of the Command resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commandId(java.lang.String commandId) {
            this.commandId = commandId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommandReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommandReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommandReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommandReference {
        private final java.lang.String commandArn;
        private final java.lang.String commandId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commandArn = software.amazon.jsii.Kernel.get(this, "commandArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.commandId = software.amazon.jsii.Kernel.get(this, "commandId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commandArn = java.util.Objects.requireNonNull(builder.commandArn, "commandArn is required");
            this.commandId = java.util.Objects.requireNonNull(builder.commandId, "commandId is required");
        }

        @Override
        public final java.lang.String getCommandArn() {
            return this.commandArn;
        }

        @Override
        public final java.lang.String getCommandId() {
            return this.commandId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("commandArn", om.valueToTree(this.getCommandArn()));
            data.set("commandId", om.valueToTree(this.getCommandId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CommandReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommandReference.Jsii$Proxy that = (CommandReference.Jsii$Proxy) o;

            if (!commandArn.equals(that.commandArn)) return false;
            return this.commandId.equals(that.commandId);
        }

        @Override
        public final int hashCode() {
            int result = this.commandArn.hashCode();
            result = 31 * result + (this.commandId.hashCode());
            return result;
        }
    }
}
