package software.amazon.awscdk.services.iot;

/**
 * A reference to a Dimension resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * DimensionReference dimensionReference = DimensionReference.builder()
 *         .dimensionArn("dimensionArn")
 *         .dimensionName("dimensionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.687Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.DimensionReference")
@software.amazon.jsii.Jsii.Proxy(DimensionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DimensionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Dimension resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDimensionArn();

    /**
     * The Name of the Dimension resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDimensionName();

    /**
     * @return a {@link Builder} of {@link DimensionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DimensionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DimensionReference> {
        java.lang.String dimensionArn;
        java.lang.String dimensionName;

        /**
         * Sets the value of {@link DimensionReference#getDimensionArn}
         * @param dimensionArn The ARN of the Dimension resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensionArn(java.lang.String dimensionArn) {
            this.dimensionArn = dimensionArn;
            return this;
        }

        /**
         * Sets the value of {@link DimensionReference#getDimensionName}
         * @param dimensionName The Name of the Dimension resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensionName(java.lang.String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DimensionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DimensionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DimensionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionReference {
        private final java.lang.String dimensionArn;
        private final java.lang.String dimensionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dimensionArn = software.amazon.jsii.Kernel.get(this, "dimensionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensionName = software.amazon.jsii.Kernel.get(this, "dimensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dimensionArn = java.util.Objects.requireNonNull(builder.dimensionArn, "dimensionArn is required");
            this.dimensionName = java.util.Objects.requireNonNull(builder.dimensionName, "dimensionName is required");
        }

        @Override
        public final java.lang.String getDimensionArn() {
            return this.dimensionArn;
        }

        @Override
        public final java.lang.String getDimensionName() {
            return this.dimensionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dimensionArn", om.valueToTree(this.getDimensionArn()));
            data.set("dimensionName", om.valueToTree(this.getDimensionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.DimensionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DimensionReference.Jsii$Proxy that = (DimensionReference.Jsii$Proxy) o;

            if (!dimensionArn.equals(that.dimensionArn)) return false;
            return this.dimensionName.equals(that.dimensionName);
        }

        @Override
        public final int hashCode() {
            int result = this.dimensionArn.hashCode();
            result = 31 * result + (this.dimensionName.hashCode());
            return result;
        }
    }
}
