package software.amazon.awscdk.services.iot;

/**
 * A reference to a SoftwarePackageVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * SoftwarePackageVersionReference softwarePackageVersionReference = SoftwarePackageVersionReference.builder()
 *         .packageName("packageName")
 *         .versionName("versionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.713Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.SoftwarePackageVersionReference")
@software.amazon.jsii.Jsii.Proxy(SoftwarePackageVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SoftwarePackageVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PackageName of the SoftwarePackageVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageName();

    /**
     * The VersionName of the SoftwarePackageVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionName();

    /**
     * @return a {@link Builder} of {@link SoftwarePackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SoftwarePackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SoftwarePackageVersionReference> {
        java.lang.String packageName;
        java.lang.String versionName;

        /**
         * Sets the value of {@link SoftwarePackageVersionReference#getPackageName}
         * @param packageName The PackageName of the SoftwarePackageVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageName(java.lang.String packageName) {
            this.packageName = packageName;
            return this;
        }

        /**
         * Sets the value of {@link SoftwarePackageVersionReference#getVersionName}
         * @param versionName The VersionName of the SoftwarePackageVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(java.lang.String versionName) {
            this.versionName = versionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SoftwarePackageVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SoftwarePackageVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SoftwarePackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SoftwarePackageVersionReference {
        private final java.lang.String packageName;
        private final java.lang.String versionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.packageName = software.amazon.jsii.Kernel.get(this, "packageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionName = software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.packageName = java.util.Objects.requireNonNull(builder.packageName, "packageName is required");
            this.versionName = java.util.Objects.requireNonNull(builder.versionName, "versionName is required");
        }

        @Override
        public final java.lang.String getPackageName() {
            return this.packageName;
        }

        @Override
        public final java.lang.String getVersionName() {
            return this.versionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("packageName", om.valueToTree(this.getPackageName()));
            data.set("versionName", om.valueToTree(this.getVersionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.SoftwarePackageVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SoftwarePackageVersionReference.Jsii$Proxy that = (SoftwarePackageVersionReference.Jsii$Proxy) o;

            if (!packageName.equals(that.packageName)) return false;
            return this.versionName.equals(that.versionName);
        }

        @Override
        public final int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + (this.versionName.hashCode());
            return result;
        }
    }
}
