package software.amazon.awscdk.services.iot;

/**
 * A reference to a Thing resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * ThingReference thingReference = ThingReference.builder()
 *         .thingArn("thingArn")
 *         .thingName("thingName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.ThingReference")
@software.amazon.jsii.Jsii.Proxy(ThingReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThingReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Thing resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingArn();

    /**
     * The ThingName of the Thing resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingName();

    /**
     * @return a {@link Builder} of {@link ThingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThingReference> {
        java.lang.String thingArn;
        java.lang.String thingName;

        /**
         * Sets the value of {@link ThingReference#getThingArn}
         * @param thingArn The ARN of the Thing resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingArn(java.lang.String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        /**
         * Sets the value of {@link ThingReference#getThingName}
         * @param thingName The ThingName of the Thing resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingName(java.lang.String thingName) {
            this.thingName = thingName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThingReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThingReference {
        private final java.lang.String thingArn;
        private final java.lang.String thingName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingName = software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.thingArn = java.util.Objects.requireNonNull(builder.thingArn, "thingArn is required");
            this.thingName = java.util.Objects.requireNonNull(builder.thingName, "thingName is required");
        }

        @Override
        public final java.lang.String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final java.lang.String getThingName() {
            return this.thingName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("thingArn", om.valueToTree(this.getThingArn()));
            data.set("thingName", om.valueToTree(this.getThingName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.ThingReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThingReference.Jsii$Proxy that = (ThingReference.Jsii$Proxy) o;

            if (!thingArn.equals(that.thingArn)) return false;
            return this.thingName.equals(that.thingName);
        }

        @Override
        public final int hashCode() {
            int result = this.thingArn.hashCode();
            result = 31 * result + (this.thingName.hashCode());
            return result;
        }
    }
}
