package software.amazon.awscdk.services.iot;

/**
 * A reference to a TopicRuleDestination resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * TopicRuleDestinationReference topicRuleDestinationReference = TopicRuleDestinationReference.builder()
 *         .topicRuleDestinationArn("topicRuleDestinationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.TopicRuleDestinationReference")
@software.amazon.jsii.Jsii.Proxy(TopicRuleDestinationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicRuleDestinationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the TopicRuleDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicRuleDestinationArn();

    /**
     * @return a {@link Builder} of {@link TopicRuleDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicRuleDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicRuleDestinationReference> {
        java.lang.String topicRuleDestinationArn;

        /**
         * Sets the value of {@link TopicRuleDestinationReference#getTopicRuleDestinationArn}
         * @param topicRuleDestinationArn The Arn of the TopicRuleDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicRuleDestinationArn(java.lang.String topicRuleDestinationArn) {
            this.topicRuleDestinationArn = topicRuleDestinationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicRuleDestinationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicRuleDestinationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicRuleDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicRuleDestinationReference {
        private final java.lang.String topicRuleDestinationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topicRuleDestinationArn = software.amazon.jsii.Kernel.get(this, "topicRuleDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topicRuleDestinationArn = java.util.Objects.requireNonNull(builder.topicRuleDestinationArn, "topicRuleDestinationArn is required");
        }

        @Override
        public final java.lang.String getTopicRuleDestinationArn() {
            return this.topicRuleDestinationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topicRuleDestinationArn", om.valueToTree(this.getTopicRuleDestinationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.TopicRuleDestinationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicRuleDestinationReference.Jsii$Proxy that = (TopicRuleDestinationReference.Jsii$Proxy) o;

            return this.topicRuleDestinationArn.equals(that.topicRuleDestinationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.topicRuleDestinationArn.hashCode();
            return result;
        }
    }
}
