package software.amazon.awscdk.services.iotevents;

/**
 * Properties for defining a <code>CfnDetectorModel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModelProps")
@software.amazon.jsii.Jsii.Proxy(CfnDetectorModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDetectorModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information that defines how a detector operates.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotevents.CfnDetectorModel.DetectorModelDefinitionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDetectorModelDefinition();

    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A brief description of the detector model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorModelDescription() {
        return null;
    }

    /**
     * The name of the detector model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorModelName() {
        return null;
    }

    /**
     * Information about the order in which events are evaluated and how actions are executed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluationMethod() {
        return null;
    }

    /**
     * The value used to identify a detector instance.
     * <p>
     * When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.
     * <p>
     * This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDetectorModelProps> {
        java.lang.Object detectorModelDefinition;
        java.lang.String roleArn;
        java.lang.String detectorModelDescription;
        java.lang.String detectorModelName;
        java.lang.String evaluationMethod;
        java.lang.String key;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDetectorModelProps#getDetectorModelDefinition}
         * @param detectorModelDefinition Information that defines how a detector operates. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDefinition(software.amazon.awscdk.IResolvable detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getDetectorModelDefinition}
         * @param detectorModelDefinition Information that defines how a detector operates. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDefinition(software.amazon.awscdk.services.iotevents.CfnDetectorModel.DetectorModelDefinitionProperty detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getRoleArn}
         * @param roleArn The ARN of the role that grants permission to AWS IoT Events to perform its operations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getDetectorModelDescription}
         * @param detectorModelDescription A brief description of the detector model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDescription(java.lang.String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getDetectorModelName}
         * @param detectorModelName The name of the detector model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelName(java.lang.String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getEvaluationMethod}
         * @param evaluationMethod Information about the order in which events are evaluated and how actions are executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationMethod(java.lang.String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getKey}
         * @param key The value used to identify a detector instance.
         *            When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.
         *            <p>
         *            This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorModelProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDetectorModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDetectorModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDetectorModelProps {
        private final java.lang.Object detectorModelDefinition;
        private final java.lang.String roleArn;
        private final java.lang.String detectorModelDescription;
        private final java.lang.String detectorModelName;
        private final java.lang.String evaluationMethod;
        private final java.lang.String key;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorModelDefinition = software.amazon.jsii.Kernel.get(this, "detectorModelDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorModelDescription = software.amazon.jsii.Kernel.get(this, "detectorModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorModelName = software.amazon.jsii.Kernel.get(this, "detectorModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationMethod = software.amazon.jsii.Kernel.get(this, "evaluationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorModelDefinition = java.util.Objects.requireNonNull(builder.detectorModelDefinition, "detectorModelDefinition is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.detectorModelDescription = builder.detectorModelDescription;
            this.detectorModelName = builder.detectorModelName;
            this.evaluationMethod = builder.evaluationMethod;
            this.key = builder.key;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDetectorModelDefinition() {
            return this.detectorModelDefinition;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getDetectorModelDescription() {
            return this.detectorModelDescription;
        }

        @Override
        public final java.lang.String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final java.lang.String getEvaluationMethod() {
            return this.evaluationMethod;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorModelDefinition", om.valueToTree(this.getDetectorModelDefinition()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDetectorModelDescription() != null) {
                data.set("detectorModelDescription", om.valueToTree(this.getDetectorModelDescription()));
            }
            if (this.getDetectorModelName() != null) {
                data.set("detectorModelName", om.valueToTree(this.getDetectorModelName()));
            }
            if (this.getEvaluationMethod() != null) {
                data.set("evaluationMethod", om.valueToTree(this.getEvaluationMethod()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDetectorModelProps.Jsii$Proxy that = (CfnDetectorModelProps.Jsii$Proxy) o;

            if (!detectorModelDefinition.equals(that.detectorModelDefinition)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.detectorModelDescription != null ? !this.detectorModelDescription.equals(that.detectorModelDescription) : that.detectorModelDescription != null) return false;
            if (this.detectorModelName != null ? !this.detectorModelName.equals(that.detectorModelName) : that.detectorModelName != null) return false;
            if (this.evaluationMethod != null ? !this.evaluationMethod.equals(that.evaluationMethod) : that.evaluationMethod != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detectorModelDefinition.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.detectorModelDescription != null ? this.detectorModelDescription.hashCode() : 0);
            result = 31 * result + (this.detectorModelName != null ? this.detectorModelName.hashCode() : 0);
            result = 31 * result + (this.evaluationMethod != null ? this.evaluationMethod.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
