package software.amazon.awscdk.services.iotevents;

/**
 * A reference to a DetectorModel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * DetectorModelReference detectorModelReference = DetectorModelReference.builder()
 *         .detectorModelName("detectorModelName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.837Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.DetectorModelReference")
@software.amazon.jsii.Jsii.Proxy(DetectorModelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DetectorModelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DetectorModelName of the DetectorModel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorModelName();

    /**
     * @return a {@link Builder} of {@link DetectorModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DetectorModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DetectorModelReference> {
        java.lang.String detectorModelName;

        /**
         * Sets the value of {@link DetectorModelReference#getDetectorModelName}
         * @param detectorModelName The DetectorModelName of the DetectorModel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelName(java.lang.String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DetectorModelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DetectorModelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DetectorModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DetectorModelReference {
        private final java.lang.String detectorModelName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorModelName = software.amazon.jsii.Kernel.get(this, "detectorModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorModelName = java.util.Objects.requireNonNull(builder.detectorModelName, "detectorModelName is required");
        }

        @Override
        public final java.lang.String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorModelName", om.valueToTree(this.getDetectorModelName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.DetectorModelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DetectorModelReference.Jsii$Proxy that = (DetectorModelReference.Jsii$Proxy) o;

            return this.detectorModelName.equals(that.detectorModelName);
        }

        @Override
        public final int hashCode() {
            int result = this.detectorModelName.hashCode();
            return result;
        }
    }
}
