package software.amazon.awscdk.services.iotfleetwise;

/**
 * A reference to a ModelManifest resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * ModelManifestReference modelManifestReference = ModelManifestReference.builder()
 *         .modelManifestArn("modelManifestArn")
 *         .modelManifestName("modelManifestName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.ModelManifestReference")
@software.amazon.jsii.Jsii.Proxy(ModelManifestReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModelManifestReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ModelManifest resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn();

    /**
     * The Name of the ModelManifest resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelManifestName();

    /**
     * @return a {@link Builder} of {@link ModelManifestReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModelManifestReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ModelManifestReference> {
        java.lang.String modelManifestArn;
        java.lang.String modelManifestName;

        /**
         * Sets the value of {@link ModelManifestReference#getModelManifestArn}
         * @param modelManifestArn The ARN of the ModelManifest resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(java.lang.String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        /**
         * Sets the value of {@link ModelManifestReference#getModelManifestName}
         * @param modelManifestName The Name of the ModelManifest resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestName(java.lang.String modelManifestName) {
            this.modelManifestName = modelManifestName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelManifestReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ModelManifestReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModelManifestReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelManifestReference {
        private final java.lang.String modelManifestArn;
        private final java.lang.String modelManifestName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.modelManifestArn = software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelManifestName = software.amazon.jsii.Kernel.get(this, "modelManifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.modelManifestArn = java.util.Objects.requireNonNull(builder.modelManifestArn, "modelManifestArn is required");
            this.modelManifestName = java.util.Objects.requireNonNull(builder.modelManifestName, "modelManifestName is required");
        }

        @Override
        public final java.lang.String getModelManifestArn() {
            return this.modelManifestArn;
        }

        @Override
        public final java.lang.String getModelManifestName() {
            return this.modelManifestName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("modelManifestArn", om.valueToTree(this.getModelManifestArn()));
            data.set("modelManifestName", om.valueToTree(this.getModelManifestName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.ModelManifestReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModelManifestReference.Jsii$Proxy that = (ModelManifestReference.Jsii$Proxy) o;

            if (!modelManifestArn.equals(that.modelManifestArn)) return false;
            return this.modelManifestName.equals(that.modelManifestName);
        }

        @Override
        public final int hashCode() {
            int result = this.modelManifestArn.hashCode();
            result = 31 * result + (this.modelManifestName.hashCode());
            return result;
        }
    }
}
