package software.amazon.awscdk.services.iotfleetwise;

/**
 * A reference to a SignalCatalog resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * SignalCatalogReference signalCatalogReference = SignalCatalogReference.builder()
 *         .signalCatalogArn("signalCatalogArn")
 *         .signalCatalogName("signalCatalogName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.SignalCatalogReference")
@software.amazon.jsii.Jsii.Proxy(SignalCatalogReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignalCatalogReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SignalCatalog resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogArn();

    /**
     * The Name of the SignalCatalog resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogName();

    /**
     * @return a {@link Builder} of {@link SignalCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignalCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignalCatalogReference> {
        java.lang.String signalCatalogArn;
        java.lang.String signalCatalogName;

        /**
         * Sets the value of {@link SignalCatalogReference#getSignalCatalogArn}
         * @param signalCatalogArn The ARN of the SignalCatalog resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogArn(java.lang.String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        /**
         * Sets the value of {@link SignalCatalogReference#getSignalCatalogName}
         * @param signalCatalogName The Name of the SignalCatalog resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogName(java.lang.String signalCatalogName) {
            this.signalCatalogName = signalCatalogName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignalCatalogReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignalCatalogReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignalCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalCatalogReference {
        private final java.lang.String signalCatalogArn;
        private final java.lang.String signalCatalogName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signalCatalogArn = software.amazon.jsii.Kernel.get(this, "signalCatalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signalCatalogName = software.amazon.jsii.Kernel.get(this, "signalCatalogName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signalCatalogArn = java.util.Objects.requireNonNull(builder.signalCatalogArn, "signalCatalogArn is required");
            this.signalCatalogName = java.util.Objects.requireNonNull(builder.signalCatalogName, "signalCatalogName is required");
        }

        @Override
        public final java.lang.String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        @Override
        public final java.lang.String getSignalCatalogName() {
            return this.signalCatalogName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signalCatalogArn", om.valueToTree(this.getSignalCatalogArn()));
            data.set("signalCatalogName", om.valueToTree(this.getSignalCatalogName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.SignalCatalogReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignalCatalogReference.Jsii$Proxy that = (SignalCatalogReference.Jsii$Proxy) o;

            if (!signalCatalogArn.equals(that.signalCatalogArn)) return false;
            return this.signalCatalogName.equals(that.signalCatalogName);
        }

        @Override
        public final int hashCode() {
            int result = this.signalCatalogArn.hashCode();
            result = 31 * result + (this.signalCatalogName.hashCode());
            return result;
        }
    }
}
