package software.amazon.awscdk.services.iotfleetwise;

/**
 * A reference to a Vehicle resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * VehicleReference vehicleReference = VehicleReference.builder()
 *         .vehicleArn("vehicleArn")
 *         .vehicleName("vehicleName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.896Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.VehicleReference")
@software.amazon.jsii.Jsii.Proxy(VehicleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VehicleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Vehicle resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVehicleArn();

    /**
     * The Name of the Vehicle resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVehicleName();

    /**
     * @return a {@link Builder} of {@link VehicleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VehicleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VehicleReference> {
        java.lang.String vehicleArn;
        java.lang.String vehicleName;

        /**
         * Sets the value of {@link VehicleReference#getVehicleArn}
         * @param vehicleArn The ARN of the Vehicle resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vehicleArn(java.lang.String vehicleArn) {
            this.vehicleArn = vehicleArn;
            return this;
        }

        /**
         * Sets the value of {@link VehicleReference#getVehicleName}
         * @param vehicleName The Name of the Vehicle resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vehicleName(java.lang.String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VehicleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VehicleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VehicleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VehicleReference {
        private final java.lang.String vehicleArn;
        private final java.lang.String vehicleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vehicleArn = software.amazon.jsii.Kernel.get(this, "vehicleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vehicleName = software.amazon.jsii.Kernel.get(this, "vehicleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vehicleArn = java.util.Objects.requireNonNull(builder.vehicleArn, "vehicleArn is required");
            this.vehicleName = java.util.Objects.requireNonNull(builder.vehicleName, "vehicleName is required");
        }

        @Override
        public final java.lang.String getVehicleArn() {
            return this.vehicleArn;
        }

        @Override
        public final java.lang.String getVehicleName() {
            return this.vehicleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vehicleArn", om.valueToTree(this.getVehicleArn()));
            data.set("vehicleName", om.valueToTree(this.getVehicleName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.VehicleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VehicleReference.Jsii$Proxy that = (VehicleReference.Jsii$Proxy) o;

            if (!vehicleArn.equals(that.vehicleArn)) return false;
            return this.vehicleName.equals(that.vehicleName);
        }

        @Override
        public final int hashCode() {
            int result = this.vehicleArn.hashCode();
            result = 31 * result + (this.vehicleName.hashCode());
            return result;
        }
    }
}
