package software.amazon.awscdk.services.iotsitewise;

/**
 * A reference to a AccessPolicy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * AccessPolicyReference accessPolicyReference = AccessPolicyReference.builder()
 *         .accessPolicyArn("accessPolicyArn")
 *         .accessPolicyId("accessPolicyId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.897Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.AccessPolicyReference")
@software.amazon.jsii.Jsii.Proxy(AccessPolicyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPolicyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AccessPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessPolicyArn();

    /**
     * The AccessPolicyId of the AccessPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessPolicyId();

    /**
     * @return a {@link Builder} of {@link AccessPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPolicyReference> {
        java.lang.String accessPolicyArn;
        java.lang.String accessPolicyId;

        /**
         * Sets the value of {@link AccessPolicyReference#getAccessPolicyArn}
         * @param accessPolicyArn The ARN of the AccessPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyArn(java.lang.String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessPolicyReference#getAccessPolicyId}
         * @param accessPolicyId The AccessPolicyId of the AccessPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyId(java.lang.String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPolicyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPolicyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPolicyReference {
        private final java.lang.String accessPolicyArn;
        private final java.lang.String accessPolicyId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicyArn = software.amazon.jsii.Kernel.get(this, "accessPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPolicyId = software.amazon.jsii.Kernel.get(this, "accessPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicyArn = java.util.Objects.requireNonNull(builder.accessPolicyArn, "accessPolicyArn is required");
            this.accessPolicyId = java.util.Objects.requireNonNull(builder.accessPolicyId, "accessPolicyId is required");
        }

        @Override
        public final java.lang.String getAccessPolicyArn() {
            return this.accessPolicyArn;
        }

        @Override
        public final java.lang.String getAccessPolicyId() {
            return this.accessPolicyId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessPolicyArn", om.valueToTree(this.getAccessPolicyArn()));
            data.set("accessPolicyId", om.valueToTree(this.getAccessPolicyId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.AccessPolicyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPolicyReference.Jsii$Proxy that = (AccessPolicyReference.Jsii$Proxy) o;

            if (!accessPolicyArn.equals(that.accessPolicyArn)) return false;
            return this.accessPolicyId.equals(that.accessPolicyId);
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicyArn.hashCode();
            result = 31 * result + (this.accessPolicyId.hashCode());
            return result;
        }
    }
}
