package software.amazon.awscdk.services.iotsitewise;

/**
 * A reference to a Asset resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * AssetReference assetReference = AssetReference.builder()
 *         .assetArn("assetArn")
 *         .assetId("assetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.897Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.AssetReference")
@software.amazon.jsii.Jsii.Proxy(AssetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Asset resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetArn();

    /**
     * The AssetId of the Asset resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetId();

    /**
     * @return a {@link Builder} of {@link AssetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetReference> {
        java.lang.String assetArn;
        java.lang.String assetId;

        /**
         * Sets the value of {@link AssetReference#getAssetArn}
         * @param assetArn The ARN of the Asset resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetArn(java.lang.String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        /**
         * Sets the value of {@link AssetReference#getAssetId}
         * @param assetId The AssetId of the Asset resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetId(java.lang.String assetId) {
            this.assetId = assetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetReference {
        private final java.lang.String assetArn;
        private final java.lang.String assetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetArn = software.amazon.jsii.Kernel.get(this, "assetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetArn = java.util.Objects.requireNonNull(builder.assetArn, "assetArn is required");
            this.assetId = java.util.Objects.requireNonNull(builder.assetId, "assetId is required");
        }

        @Override
        public final java.lang.String getAssetArn() {
            return this.assetArn;
        }

        @Override
        public final java.lang.String getAssetId() {
            return this.assetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assetArn", om.valueToTree(this.getAssetArn()));
            data.set("assetId", om.valueToTree(this.getAssetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.AssetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetReference.Jsii$Proxy that = (AssetReference.Jsii$Proxy) o;

            if (!assetArn.equals(that.assetArn)) return false;
            return this.assetId.equals(that.assetId);
        }

        @Override
        public final int hashCode() {
            int result = this.assetArn.hashCode();
            result = 31 * result + (this.assetId.hashCode());
            return result;
        }
    }
}
