package software.amazon.awscdk.services.iotsitewise;

/**
 * A reference to a Dataset resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * DatasetReference datasetReference = DatasetReference.builder()
 *         .datasetArn("datasetArn")
 *         .datasetId("datasetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:07.970Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.DatasetReference")
@software.amazon.jsii.Jsii.Proxy(DatasetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatasetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Dataset resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatasetArn();

    /**
     * The DatasetId of the Dataset resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatasetId();

    /**
     * @return a {@link Builder} of {@link DatasetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatasetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatasetReference> {
        java.lang.String datasetArn;
        java.lang.String datasetId;

        /**
         * Sets the value of {@link DatasetReference#getDatasetArn}
         * @param datasetArn The ARN of the Dataset resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetArn(java.lang.String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        /**
         * Sets the value of {@link DatasetReference#getDatasetId}
         * @param datasetId The DatasetId of the Dataset resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetId(java.lang.String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatasetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatasetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatasetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetReference {
        private final java.lang.String datasetArn;
        private final java.lang.String datasetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datasetArn = software.amazon.jsii.Kernel.get(this, "datasetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datasetId = software.amazon.jsii.Kernel.get(this, "datasetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datasetArn = java.util.Objects.requireNonNull(builder.datasetArn, "datasetArn is required");
            this.datasetId = java.util.Objects.requireNonNull(builder.datasetId, "datasetId is required");
        }

        @Override
        public final java.lang.String getDatasetArn() {
            return this.datasetArn;
        }

        @Override
        public final java.lang.String getDatasetId() {
            return this.datasetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datasetArn", om.valueToTree(this.getDatasetArn()));
            data.set("datasetId", om.valueToTree(this.getDatasetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.DatasetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatasetReference.Jsii$Proxy that = (DatasetReference.Jsii$Proxy) o;

            if (!datasetArn.equals(that.datasetArn)) return false;
            return this.datasetId.equals(that.datasetId);
        }

        @Override
        public final int hashCode() {
            int result = this.datasetArn.hashCode();
            result = 31 * result + (this.datasetId.hashCode());
            return result;
        }
    }
}
