package software.amazon.awscdk.services.iottwinmaker;

/**
 * A reference to a Scene resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iottwinmaker.*;
 * SceneReference sceneReference = SceneReference.builder()
 *         .sceneArn("sceneArn")
 *         .sceneId("sceneId")
 *         .workspaceId("workspaceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.015Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.SceneReference")
@software.amazon.jsii.Jsii.Proxy(SceneReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SceneReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Scene resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSceneArn();

    /**
     * The SceneId of the Scene resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSceneId();

    /**
     * The WorkspaceId of the Scene resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId();

    /**
     * @return a {@link Builder} of {@link SceneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SceneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SceneReference> {
        java.lang.String sceneArn;
        java.lang.String sceneId;
        java.lang.String workspaceId;

        /**
         * Sets the value of {@link SceneReference#getSceneArn}
         * @param sceneArn The ARN of the Scene resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sceneArn(java.lang.String sceneArn) {
            this.sceneArn = sceneArn;
            return this;
        }

        /**
         * Sets the value of {@link SceneReference#getSceneId}
         * @param sceneId The SceneId of the Scene resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sceneId(java.lang.String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        /**
         * Sets the value of {@link SceneReference#getWorkspaceId}
         * @param workspaceId The WorkspaceId of the Scene resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(java.lang.String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SceneReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SceneReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SceneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SceneReference {
        private final java.lang.String sceneArn;
        private final java.lang.String sceneId;
        private final java.lang.String workspaceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sceneArn = software.amazon.jsii.Kernel.get(this, "sceneArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sceneId = software.amazon.jsii.Kernel.get(this, "sceneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceId = software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sceneArn = java.util.Objects.requireNonNull(builder.sceneArn, "sceneArn is required");
            this.sceneId = java.util.Objects.requireNonNull(builder.sceneId, "sceneId is required");
            this.workspaceId = java.util.Objects.requireNonNull(builder.workspaceId, "workspaceId is required");
        }

        @Override
        public final java.lang.String getSceneArn() {
            return this.sceneArn;
        }

        @Override
        public final java.lang.String getSceneId() {
            return this.sceneId;
        }

        @Override
        public final java.lang.String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sceneArn", om.valueToTree(this.getSceneArn()));
            data.set("sceneId", om.valueToTree(this.getSceneId()));
            data.set("workspaceId", om.valueToTree(this.getWorkspaceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.SceneReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SceneReference.Jsii$Proxy that = (SceneReference.Jsii$Proxy) o;

            if (!sceneArn.equals(that.sceneArn)) return false;
            if (!sceneId.equals(that.sceneId)) return false;
            return this.workspaceId.equals(that.workspaceId);
        }

        @Override
        public final int hashCode() {
            int result = this.sceneArn.hashCode();
            result = 31 * result + (this.sceneId.hashCode());
            result = 31 * result + (this.workspaceId.hashCode());
            return result;
        }
    }
}
