package software.amazon.awscdk.services.iotwireless;

/**
 * Information about an import task for wireless devices.
 * <p>
 * When creating the resource, either create a single wireless device import task using the Sidewalk manufacturing serial number (SMSN) of the wireless device, or create an import task for multiple devices by specifying both the <code>DeviceCreationFile</code> and the <code>Role</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnWirelessDeviceImportTask cfnWirelessDeviceImportTask = CfnWirelessDeviceImportTask.Builder.create(this, "MyCfnWirelessDeviceImportTask")
 *         .destinationName("destinationName")
 *         .sidewalk(SidewalkProperty.builder()
 *                 .deviceCreationFile("deviceCreationFile")
 *                 .deviceCreationFileList(List.of("deviceCreationFileList"))
 *                 .role("role")
 *                 .sidewalkManufacturingSn("sidewalkManufacturingSn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.054Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnWirelessDeviceImportTask")
public class CfnWirelessDeviceImportTask extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.iotwireless.IWirelessDeviceImportTaskRef, software.amazon.awscdk.ITaggable {

    protected CfnWirelessDeviceImportTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWirelessDeviceImportTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWirelessDeviceImportTask(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN (Amazon Resource Name) of the import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time at which the wireless device import task was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The summary information of count of wireless devices that failed to onboard to the import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrFailedImportedDevicesCount() {
        return software.amazon.jsii.Kernel.get(this, "attrFailedImportedDevicesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The import task ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The summary information of count of wireless devices that are waiting for the control log to be added to an import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrInitializedImportedDevicesCount() {
        return software.amazon.jsii.Kernel.get(this, "attrInitializedImportedDevicesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The summary information of count of wireless devices that have been onboarded to the import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrOnboardedImportedDevicesCount() {
        return software.amazon.jsii.Kernel.get(this, "attrOnboardedImportedDevicesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The summary information of count of wireless devices that are waiting in the queue to be onboarded to the import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrPendingImportedDevicesCount() {
        return software.amazon.jsii.Kernel.get(this, "attrPendingImportedDevicesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * List of Sidewalk devices that are added to the import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSidewalkDeviceCreationFileList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSidewalkDeviceCreationFileList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The status of a wireless device import task.
     * <p>
     * The status can be <code>INITIALIZING</code> , <code>INITIALIZED</code> , <code>PENDING</code> , <code>COMPLETE</code> , <code>FAILED</code> , or <code>DELETING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reason that provides additional information about the import task status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a WirelessDeviceImportTask resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.WirelessDeviceImportTaskReference getWirelessDeviceImportTaskRef() {
        return software.amazon.jsii.Kernel.get(this, "wirelessDeviceImportTaskRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotwireless.WirelessDeviceImportTaskReference.class));
    }

    /**
     * The name of the destination that describes the IoT rule to route messages from the Sidewalk devices in the import task to other applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDestinationName() {
        return software.amazon.jsii.Kernel.get(this, "destinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the destination that describes the IoT rule to route messages from the Sidewalk devices in the import task to other applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationName", java.util.Objects.requireNonNull(value, "destinationName is required"));
    }

    /**
     * The Sidewalk-related information of the wireless device import task.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask.SidewalkProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSidewalk() {
        return software.amazon.jsii.Kernel.get(this, "sidewalk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Sidewalk-related information of the wireless device import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalk(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sidewalk", java.util.Objects.requireNonNull(value, "sidewalk is required"));
    }

    /**
     * The Sidewalk-related information of the wireless device import task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalk(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask.SidewalkProperty value) {
        software.amazon.jsii.Kernel.set(this, "sidewalk", java.util.Objects.requireNonNull(value, "sidewalk is required"));
    }

    /**
     * Adds to or modifies the tags of the given resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Adds to or modifies the tags of the given resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Sidewalk-related information about a wireless device import task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * SidewalkProperty sidewalkProperty = SidewalkProperty.builder()
     *         .deviceCreationFile("deviceCreationFile")
     *         .deviceCreationFileList(List.of("deviceCreationFileList"))
     *         .role("role")
     *         .sidewalkManufacturingSn("sidewalkManufacturingSn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnWirelessDeviceImportTask.SidewalkProperty")
    @software.amazon.jsii.Jsii.Proxy(SidewalkProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SidewalkProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CSV file contained in an S3 bucket that's used for adding devices to an import task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-devicecreationfile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-devicecreationfile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceCreationFile() {
            return null;
        }

        /**
         * List of Sidewalk devices that are added to the import task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-devicecreationfilelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-devicecreationfilelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDeviceCreationFileList() {
            return null;
        }

        /**
         * The IAM role that allows  to access the CSV file in the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-sidewalkmanufacturingsn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdeviceimporttask-sidewalk.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk-sidewalkmanufacturingsn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSidewalkManufacturingSn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SidewalkProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SidewalkProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SidewalkProperty> {
            java.lang.String deviceCreationFile;
            java.util.List<java.lang.String> deviceCreationFileList;
            java.lang.String role;
            java.lang.String sidewalkManufacturingSn;

            /**
             * Sets the value of {@link SidewalkProperty#getDeviceCreationFile}
             * @param deviceCreationFile The CSV file contained in an S3 bucket that's used for adding devices to an import task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceCreationFile(java.lang.String deviceCreationFile) {
                this.deviceCreationFile = deviceCreationFile;
                return this;
            }

            /**
             * Sets the value of {@link SidewalkProperty#getDeviceCreationFileList}
             * @param deviceCreationFileList List of Sidewalk devices that are added to the import task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceCreationFileList(java.util.List<java.lang.String> deviceCreationFileList) {
                this.deviceCreationFileList = deviceCreationFileList;
                return this;
            }

            /**
             * Sets the value of {@link SidewalkProperty#getRole}
             * @param role The IAM role that allows  to access the CSV file in the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Sets the value of {@link SidewalkProperty#getSidewalkManufacturingSn}
             * @param sidewalkManufacturingSn The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sidewalkManufacturingSn(java.lang.String sidewalkManufacturingSn) {
                this.sidewalkManufacturingSn = sidewalkManufacturingSn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SidewalkProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SidewalkProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SidewalkProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SidewalkProperty {
            private final java.lang.String deviceCreationFile;
            private final java.util.List<java.lang.String> deviceCreationFileList;
            private final java.lang.String role;
            private final java.lang.String sidewalkManufacturingSn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceCreationFile = software.amazon.jsii.Kernel.get(this, "deviceCreationFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceCreationFileList = software.amazon.jsii.Kernel.get(this, "deviceCreationFileList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sidewalkManufacturingSn = software.amazon.jsii.Kernel.get(this, "sidewalkManufacturingSn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceCreationFile = builder.deviceCreationFile;
                this.deviceCreationFileList = builder.deviceCreationFileList;
                this.role = builder.role;
                this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
            }

            @Override
            public final java.lang.String getDeviceCreationFile() {
                return this.deviceCreationFile;
            }

            @Override
            public final java.util.List<java.lang.String> getDeviceCreationFileList() {
                return this.deviceCreationFileList;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            public final java.lang.String getSidewalkManufacturingSn() {
                return this.sidewalkManufacturingSn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceCreationFile() != null) {
                    data.set("deviceCreationFile", om.valueToTree(this.getDeviceCreationFile()));
                }
                if (this.getDeviceCreationFileList() != null) {
                    data.set("deviceCreationFileList", om.valueToTree(this.getDeviceCreationFileList()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }
                if (this.getSidewalkManufacturingSn() != null) {
                    data.set("sidewalkManufacturingSn", om.valueToTree(this.getSidewalkManufacturingSn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnWirelessDeviceImportTask.SidewalkProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SidewalkProperty.Jsii$Proxy that = (SidewalkProperty.Jsii$Proxy) o;

                if (this.deviceCreationFile != null ? !this.deviceCreationFile.equals(that.deviceCreationFile) : that.deviceCreationFile != null) return false;
                if (this.deviceCreationFileList != null ? !this.deviceCreationFileList.equals(that.deviceCreationFileList) : that.deviceCreationFileList != null) return false;
                if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
                return this.sidewalkManufacturingSn != null ? this.sidewalkManufacturingSn.equals(that.sidewalkManufacturingSn) : that.sidewalkManufacturingSn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceCreationFile != null ? this.deviceCreationFile.hashCode() : 0;
                result = 31 * result + (this.deviceCreationFileList != null ? this.deviceCreationFileList.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                result = 31 * result + (this.sidewalkManufacturingSn != null ? this.sidewalkManufacturingSn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTaskProps.Builder();
        }

        /**
         * The name of the destination that describes the IoT rule to route messages from the Sidewalk devices in the import task to other applications.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-destinationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-destinationname</a>
         * @param destinationName The name of the destination that describes the IoT rule to route messages from the Sidewalk devices in the import task to other applications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(final java.lang.String destinationName) {
            this.props.destinationName(destinationName);
            return this;
        }

        /**
         * The Sidewalk-related information of the wireless device import task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk</a>
         * @param sidewalk The Sidewalk-related information of the wireless device import task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(final software.amazon.awscdk.IResolvable sidewalk) {
            this.props.sidewalk(sidewalk);
            return this;
        }
        /**
         * The Sidewalk-related information of the wireless device import task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-sidewalk</a>
         * @param sidewalk The Sidewalk-related information of the wireless device import task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(final software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask.SidewalkProperty sidewalk) {
            this.props.sidewalk(sidewalk);
            return this;
        }

        /**
         * Adds to or modifies the tags of the given resource.
         * <p>
         * Tags are metadata that you can use to manage a resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdeviceimporttask.html#cfn-iotwireless-wirelessdeviceimporttask-tags</a>
         * @param tags Adds to or modifies the tags of the given resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask build() {
            return new software.amazon.awscdk.services.iotwireless.CfnWirelessDeviceImportTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
