package software.amazon.awscdk.services.iotwireless;

/**
 * A reference to a PartnerAccount resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * PartnerAccountReference partnerAccountReference = PartnerAccountReference.builder()
 *         .partnerAccountArn("partnerAccountArn")
 *         .partnerAccountId("partnerAccountId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.PartnerAccountReference")
@software.amazon.jsii.Jsii.Proxy(PartnerAccountReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PartnerAccountReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PartnerAccount resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPartnerAccountArn();

    /**
     * The PartnerAccountId of the PartnerAccount resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPartnerAccountId();

    /**
     * @return a {@link Builder} of {@link PartnerAccountReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PartnerAccountReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PartnerAccountReference> {
        java.lang.String partnerAccountArn;
        java.lang.String partnerAccountId;

        /**
         * Sets the value of {@link PartnerAccountReference#getPartnerAccountArn}
         * @param partnerAccountArn The ARN of the PartnerAccount resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerAccountArn(java.lang.String partnerAccountArn) {
            this.partnerAccountArn = partnerAccountArn;
            return this;
        }

        /**
         * Sets the value of {@link PartnerAccountReference#getPartnerAccountId}
         * @param partnerAccountId The PartnerAccountId of the PartnerAccount resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerAccountId(java.lang.String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PartnerAccountReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PartnerAccountReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PartnerAccountReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PartnerAccountReference {
        private final java.lang.String partnerAccountArn;
        private final java.lang.String partnerAccountId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partnerAccountArn = software.amazon.jsii.Kernel.get(this, "partnerAccountArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partnerAccountId = software.amazon.jsii.Kernel.get(this, "partnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partnerAccountArn = java.util.Objects.requireNonNull(builder.partnerAccountArn, "partnerAccountArn is required");
            this.partnerAccountId = java.util.Objects.requireNonNull(builder.partnerAccountId, "partnerAccountId is required");
        }

        @Override
        public final java.lang.String getPartnerAccountArn() {
            return this.partnerAccountArn;
        }

        @Override
        public final java.lang.String getPartnerAccountId() {
            return this.partnerAccountId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partnerAccountArn", om.valueToTree(this.getPartnerAccountArn()));
            data.set("partnerAccountId", om.valueToTree(this.getPartnerAccountId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.PartnerAccountReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PartnerAccountReference.Jsii$Proxy that = (PartnerAccountReference.Jsii$Proxy) o;

            if (!partnerAccountArn.equals(that.partnerAccountArn)) return false;
            return this.partnerAccountId.equals(that.partnerAccountId);
        }

        @Override
        public final int hashCode() {
            int result = this.partnerAccountArn.hashCode();
            result = 31 * result + (this.partnerAccountId.hashCode());
            return result;
        }
    }
}
