package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The data processor to extract message after decompression of CloudWatch Logs.
 * <p>
 * This processor must used with <code>DecompressionProcessor</code>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processors(List.of(
 *             new DecompressionProcessor(),
 *             CloudWatchLogProcessor.Builder.create().dataMessageExtraction(true).build()))
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/Message_extraction.html">https://docs.aws.amazon.com/firehose/latest/dev/Message_extraction.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.513Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CloudWatchLogProcessor")
public class CloudWatchLogProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDataProcessor {

    protected CloudWatchLogProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudWatchLogProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudWatchLogProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessorOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Binds this processor to a destination of a delivery stream.
     * <p>
     * Implementers should use this method to grant processor invocation permissions to the provided stream and return the
     * necessary configuration to register as a processor.
     * <p>
     * @param _scope This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * The constructor props of the DataProcessor.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessorOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessorOptions.Builder();
        }

        /**
         * Extract message from CloudWatch logs.
         * <p>
         * This must be true.
         * <p>
         * @return {@code this}
         * @param dataMessageExtraction Extract message from CloudWatch logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMessageExtraction(final java.lang.Boolean dataMessageExtraction) {
            this.options.dataMessageExtraction(dataMessageExtraction);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessor build() {
            return new software.amazon.awscdk.services.kinesisfirehose.CloudWatchLogProcessor(
                this.options.build()
            );
        }
    }
}
