package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The full configuration of a data processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * DataProcessorConfig dataProcessorConfig = DataProcessorConfig.builder()
 *         .processorIdentifier(DataProcessorIdentifier.builder()
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build())
 *         .processorType("processorType")
 *         // the properties below are optional
 *         .parameters(List.of(ProcessorParameterProperty.builder()
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-processor.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-processor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.516Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DataProcessorConfig")
@software.amazon.jsii.Jsii.Proxy(DataProcessorConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataProcessorConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key-value pair that identifies the underlying processor resource.
     * <p>
     * Ignored when the <code>parameters</code> is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier getProcessorIdentifier();

    /**
     * The type of processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProcessorType();

    /**
     * The processor parameters.
     * <p>
     * Default: - No processor parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty> getParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataProcessorConfig> {
        software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier processorIdentifier;
        java.lang.String processorType;
        java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty> parameters;

        /**
         * Sets the value of {@link DataProcessorConfig#getProcessorIdentifier}
         * @param processorIdentifier The key-value pair that identifies the underlying processor resource. This parameter is required.
         *                            Ignored when the <code>parameters</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorIdentifier(software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier processorIdentifier) {
            this.processorIdentifier = processorIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorConfig#getProcessorType}
         * @param processorType The type of processor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorType(java.lang.String processorType) {
            this.processorType = processorType;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorConfig#getParameters}
         * @param parameters The processor parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.List<? extends software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty> parameters) {
            this.parameters = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty>)parameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataProcessorConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataProcessorConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataProcessorConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProcessorConfig {
        private final software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier processorIdentifier;
        private final java.lang.String processorType;
        private final java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty> parameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.processorIdentifier = software.amazon.jsii.Kernel.get(this, "processorIdentifier", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier.class));
            this.processorType = software.amazon.jsii.Kernel.get(this, "processorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.processorIdentifier = java.util.Objects.requireNonNull(builder.processorIdentifier, "processorIdentifier is required");
            this.processorType = java.util.Objects.requireNonNull(builder.processorType, "processorType is required");
            this.parameters = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty>)builder.parameters;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.DataProcessorIdentifier getProcessorIdentifier() {
            return this.processorIdentifier;
        }

        @Override
        public final java.lang.String getProcessorType() {
            return this.processorType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty> getParameters() {
            return this.parameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("processorIdentifier", om.valueToTree(this.getProcessorIdentifier()));
            data.set("processorType", om.valueToTree(this.getProcessorType()));
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DataProcessorConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataProcessorConfig.Jsii$Proxy that = (DataProcessorConfig.Jsii$Proxy) o;

            if (!processorIdentifier.equals(that.processorIdentifier)) return false;
            if (!processorType.equals(that.processorType)) return false;
            return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.processorIdentifier.hashCode();
            result = 31 * result + (this.processorType.hashCode());
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result;
        }
    }
}
