package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Options for DecompressionProcessor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * DecompressionProcessorCompressionFormat decompressionProcessorCompressionFormat;
 * DecompressionProcessorOptions decompressionProcessorOptions = DecompressionProcessorOptions.builder()
 *         .compressionFormat(decompressionProcessorCompressionFormat)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.518Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DecompressionProcessorOptions")
@software.amazon.jsii.Jsii.Proxy(DecompressionProcessorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DecompressionProcessorOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The input compression format.
     * <p>
     * Default: DecompressionProcessorCompressionFormat.GZIP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat getCompressionFormat() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DecompressionProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DecompressionProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DecompressionProcessorOptions> {
        software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat compressionFormat;

        /**
         * Sets the value of {@link DecompressionProcessorOptions#getCompressionFormat}
         * @param compressionFormat The input compression format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionFormat(software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DecompressionProcessorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DecompressionProcessorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DecompressionProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecompressionProcessorOptions {
        private final software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat compressionFormat;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compressionFormat = builder.compressionFormat;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat getCompressionFormat() {
            return this.compressionFormat;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCompressionFormat() != null) {
                data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DecompressionProcessorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DecompressionProcessorOptions.Jsii$Proxy that = (DecompressionProcessorOptions.Jsii$Proxy) o;

            return this.compressionFormat != null ? this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compressionFormat != null ? this.compressionFormat.hashCode() : 0;
            return result;
        }
    }
}
