package software.amazon.awscdk.services.kinesisfirehose;

/**
 * A reference to a DeliveryStream resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * DeliveryStreamReference deliveryStreamReference = DeliveryStreamReference.builder()
 *         .deliveryStreamArn("deliveryStreamArn")
 *         .deliveryStreamName("deliveryStreamName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.520Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamReference")
@software.amazon.jsii.Jsii.Proxy(DeliveryStreamReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryStreamReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DeliveryStream resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamArn();

    /**
     * The DeliveryStreamName of the DeliveryStream resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamName();

    /**
     * @return a {@link Builder} of {@link DeliveryStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamReference> {
        java.lang.String deliveryStreamArn;
        java.lang.String deliveryStreamName;

        /**
         * Sets the value of {@link DeliveryStreamReference#getDeliveryStreamArn}
         * @param deliveryStreamArn The ARN of the DeliveryStream resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamArn(java.lang.String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamReference#getDeliveryStreamName}
         * @param deliveryStreamName The DeliveryStreamName of the DeliveryStream resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryStreamReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryStreamReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamReference {
        private final java.lang.String deliveryStreamArn;
        private final java.lang.String deliveryStreamName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryStreamArn = software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryStreamArn = java.util.Objects.requireNonNull(builder.deliveryStreamArn, "deliveryStreamArn is required");
            this.deliveryStreamName = java.util.Objects.requireNonNull(builder.deliveryStreamName, "deliveryStreamName is required");
        }

        @Override
        public final java.lang.String getDeliveryStreamArn() {
            return this.deliveryStreamArn;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryStreamArn", om.valueToTree(this.getDeliveryStreamArn()));
            data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryStreamReference.Jsii$Proxy that = (DeliveryStreamReference.Jsii$Proxy) o;

            if (!deliveryStreamArn.equals(that.deliveryStreamArn)) return false;
            return this.deliveryStreamName.equals(that.deliveryStreamName);
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryStreamArn.hashCode();
            result = 31 * result + (this.deliveryStreamName.hashCode());
            return result;
        }
    }
}
