package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for Hive JSON input format for data record format conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HiveJsonInputFormat inputFormat = HiveJsonInputFormat.Builder.create()
 *         .timestampParsers(List.of(TimestampParser.fromFormatString("yyyy-MM-dd"), TimestampParser.EPOCH_MILLIS))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.539Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.HiveJsonInputFormatProps")
@software.amazon.jsii.Jsii.Proxy(HiveJsonInputFormatProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HiveJsonInputFormatProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of TimestampParsers.
     * <p>
     * These are used to parse custom timestamp strings from input JSON into dates.
     * <p>
     * Note: Specifying a parser will override the default timestamp parser. If the default timestamp parser is required,
     * include <code>TimestampParser.DEFAULT</code> in the list of parsers along with the custom parser.
     * <p>
     * Default: the default timestamp parser is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser> getTimestampParsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HiveJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HiveJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HiveJsonInputFormatProps> {
        java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser> timestampParsers;

        /**
         * Sets the value of {@link HiveJsonInputFormatProps#getTimestampParsers}
         * @param timestampParsers List of TimestampParsers.
         *                         These are used to parse custom timestamp strings from input JSON into dates.
         *                         <p>
         *                         Note: Specifying a parser will override the default timestamp parser. If the default timestamp parser is required,
         *                         include <code>TimestampParser.DEFAULT</code> in the list of parsers along with the custom parser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder timestampParsers(java.util.List<? extends software.amazon.awscdk.services.kinesisfirehose.TimestampParser> timestampParsers) {
            this.timestampParsers = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser>)timestampParsers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HiveJsonInputFormatProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HiveJsonInputFormatProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HiveJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HiveJsonInputFormatProps {
        private final java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser> timestampParsers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.timestampParsers = software.amazon.jsii.Kernel.get(this, "timestampParsers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.TimestampParser.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.timestampParsers = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser>)builder.timestampParsers;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.kinesisfirehose.TimestampParser> getTimestampParsers() {
            return this.timestampParsers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTimestampParsers() != null) {
                data.set("timestampParsers", om.valueToTree(this.getTimestampParsers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.HiveJsonInputFormatProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HiveJsonInputFormatProps.Jsii$Proxy that = (HiveJsonInputFormatProps.Jsii$Proxy) o;

            return this.timestampParsers != null ? this.timestampParsers.equals(that.timestampParsers) : that.timestampParsers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.timestampParsers != null ? this.timestampParsers.hashCode() : 0;
            return result;
        }
    }
}
