package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Represents possible input formats when performing record data conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * CfnTable schemaGlueTable;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .dataFormatConversion(DataFormatConversionProps.builder()
 *                 .schemaConfiguration(SchemaConfiguration.fromCfnTable(schemaGlueTable))
 *                 .inputFormat(InputFormat.OPENX_JSON)
 *                 .outputFormat(OutputFormat.PARQUET)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.543Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.InputFormat")
public class InputFormat extends software.amazon.jsii.JsiiObject {

    protected InputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        HIVE_JSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.InputFormat.class, "HIVE_JSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat.class));
        OPENX_JSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.InputFormat.class, "OPENX_JSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat.class));
    }

    /**
     * Parse input JSON with Hive JSON specification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat HIVE_JSON;

    /**
     * Parse input JSON with OpenX JSON specification.
     * <p>
     * This will typically suffice.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat OPENX_JSON;
}
