package software.amazon.awscdk.services.kinesisfirehose;

/**
 * This class specifies properties for ORC output format for record format conversion.
 * <p>
 * You should only need to specify an instance of this class if the default configuration does not suit your needs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OrcOutputFormat outputFormat = OrcOutputFormat.Builder.create()
 *         .formatVersion(OrcFormatVersion.V0_11)
 *         .blockSize(Size.mebibytes(256))
 *         .compression(OrcCompression.NONE)
 *         .bloomFilterColumns(List.of("columnA"))
 *         .bloomFilterFalsePositiveProbability(0.1)
 *         .dictionaryKeyThreshold(0.7)
 *         .enablePadding(true)
 *         .paddingTolerance(0.2)
 *         .rowIndexStride(9000)
 *         .stripeSize(Size.mebibytes(32))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.546Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OrcOutputFormat")
public class OrcOutputFormat extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IOutputFormat {

    protected OrcOutputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OrcOutputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OrcOutputFormat(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OrcOutputFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Renders the cloudformation properties for the output format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty createOutputFormatConfig() {
        return software.amazon.jsii.Kernel.call(this, "createOutputFormatConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty.class));
    }

    /**
     * Properties for the ORC output format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps.Builder props;

        private Builder() {
        }

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * Firehose uses this value for padding calculations.
         * <p>
         * Default: `Size.mebibytes(256)`
         * <p>
         * @return {@code this}
         * @param blockSize The Hadoop Distributed File System (HDFS) block size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockSize(final software.amazon.awscdk.Size blockSize) {
            this.props().blockSize(blockSize);
            return this;
        }

        /**
         * The column names for which you want Firehose to create bloom filters.
         * <p>
         * Default: no bloom filters are created
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns</a>
         * @param bloomFilterColumns The column names for which you want Firehose to create bloom filters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bloomFilterColumns(final java.util.List<java.lang.String> bloomFilterColumns) {
            this.props().bloomFilterColumns(bloomFilterColumns);
            return this;
        }

        /**
         * The Bloom filter false positive probability (FPP).
         * <p>
         * The lower the FPP, the bigger the bloom filter.
         * <p>
         * Default: `0.05`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability</a>
         * @param bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bloomFilterFalsePositiveProbability(final java.lang.Number bloomFilterFalsePositiveProbability) {
            this.props().bloomFilterFalsePositiveProbability(bloomFilterFalsePositiveProbability);
            return this;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The possible values are <code>NONE</code> , <code>SNAPPY</code> , and <code>ZLIB</code>.
         * Use <code>SNAPPY</code> for higher decompression speed.
         * Use <code>GZIP</code> if the compression ratio is more important than speed.
         * <p>
         * Default: `SNAPPY`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression</a>
         * @param compression The compression code to use over data blocks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final software.amazon.awscdk.services.kinesisfirehose.OrcCompression compression) {
            this.props().compression(compression);
            return this;
        }

        /**
         * Determines whether dictionary encoding should be applied to a column.
         * <p>
         * If the number of distinct keys (unique values) in a column exceeds this fraction of the total non-null rows in that column, dictionary encoding will be turned off for that specific column.
         * <p>
         * To turn off dictionary encoding, set this threshold to 0. To always use dictionary encoding, set this threshold to 1.
         * <p>
         * Default: `0.8`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold</a>
         * @param dictionaryKeyThreshold Determines whether dictionary encoding should be applied to a column. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dictionaryKeyThreshold(final java.lang.Number dictionaryKeyThreshold) {
            this.props().dictionaryKeyThreshold(dictionaryKeyThreshold);
            return this;
        }

        /**
         * Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * <p>
         * Default: `false`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding</a>
         * @param enablePadding Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePadding(final java.lang.Boolean enablePadding) {
            this.props().enablePadding(enablePadding);
            return this;
        }

        /**
         * The version of the ORC format to write.
         * <p>
         * The possible values are <code>V0_11</code> and <code>V0_12</code>.
         * <p>
         * Default: `V0_12`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion</a>
         * @param formatVersion The version of the ORC format to write. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formatVersion(final software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion formatVersion) {
            this.props().formatVersion(formatVersion);
            return this;
        }

        /**
         * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
         * <p>
         * The default value is 0.05, which means 5 percent of stripe size.
         * <p>
         * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block.
         * In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space.
         * This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
         * <p>
         * Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
         * <p>
         * Default: `0.05` if `enablePadding` is `true`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance</a>
         * @param paddingTolerance A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paddingTolerance(final java.lang.Number paddingTolerance) {
            this.props().paddingTolerance(paddingTolerance);
            return this;
        }

        /**
         * The number of rows between index entries.
         * <p>
         * Default: 10000
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride</a>
         * @param rowIndexStride The number of rows between index entries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowIndexStride(final java.lang.Number rowIndexStride) {
            this.props().rowIndexStride(rowIndexStride);
            return this;
        }

        /**
         * The number of bytes in each stripe.
         * <p>
         * The default is 64 MiB and the minimum is 8 MiB.
         * <p>
         * Default: `Size.mebibytes(64)`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes</a>
         * @param stripeSize The number of bytes in each stripe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stripeSize(final software.amazon.awscdk.Size stripeSize) {
            this.props().stripeSize(stripeSize);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat build() {
            return new software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormatProps.Builder();
            }
            return this.props;
        }
    }
}
