package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Possible compression options available for Parquet OutputFormat.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ParquetOutputFormat outputFormat = ParquetOutputFormat.Builder.create()
 *         .blockSize(Size.mebibytes(512))
 *         .compression(ParquetCompression.UNCOMPRESSED)
 *         .enableDictionaryCompression(true)
 *         .maxPadding(Size.bytes(10))
 *         .pageSize(Size.mebibytes(2))
 *         .writerVersion(ParquetWriterVersion.V2)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.548Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.ParquetCompression")
public class ParquetCompression extends software.amazon.jsii.JsiiObject {

    protected ParquetCompression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParquetCompression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        GZIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class, "GZIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class));
        SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class, "SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class));
        UNCOMPRESSED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class, "UNCOMPRESSED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class));
    }

    /**
     * Creates a new ParquetCompression instance with a custom value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.ParquetCompression of(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Gzip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.ParquetCompression GZIP;

    /**
     * Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.ParquetCompression SNAPPY;

    /**
     * Uncompressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.ParquetCompression UNCOMPRESSED;

    /**
     * the string value of the Serde Compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
