package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for Parquet output format for data record format conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ParquetOutputFormat outputFormat = ParquetOutputFormat.Builder.create()
 *         .blockSize(Size.mebibytes(512))
 *         .compression(ParquetCompression.UNCOMPRESSED)
 *         .enableDictionaryCompression(true)
 *         .maxPadding(Size.bytes(10))
 *         .pageSize(Size.mebibytes(2))
 *         .writerVersion(ParquetWriterVersion.V2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.549Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.ParquetOutputFormatProps")
@software.amazon.jsii.Jsii.Proxy(ParquetOutputFormatProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ParquetOutputFormatProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Hadoop Distributed File System (HDFS) block size.
     * <p>
     * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
     * Firehose uses this value for padding calculations.
     * <p>
     * Default: `Size.mebibytes(256)`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getBlockSize() {
        return null;
    }

    /**
     * The compression code to use over data blocks.
     * <p>
     * The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code>.
     * Use <code>SNAPPY</code> for higher decompression speed.
     * Use <code>GZIP</code> if the compression ratio is more important than speed.
     * <p>
     * Default: `SNAPPY`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ParquetCompression getCompression() {
        return null;
    }

    /**
     * Indicates whether to enable dictionary compression.
     * <p>
     * Default: `false`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDictionaryCompression() {
        return null;
    }

    /**
     * The maximum amount of padding to apply.
     * <p>
     * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
     * <p>
     * Default: no padding is applied
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMaxPadding() {
        return null;
    }

    /**
     * The Parquet page size.
     * <p>
     * Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
     * <p>
     * Default: `Size.mebibytes(1)`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getPageSize() {
        return null;
    }

    /**
     * Indicates the version of Parquet to output.
     * <p>
     * The possible values are <code>V1</code> and <code>V2</code>
     * <p>
     * Default: `V1`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion getWriterVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParquetOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParquetOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ParquetOutputFormatProps> {
        software.amazon.awscdk.Size blockSize;
        software.amazon.awscdk.services.kinesisfirehose.ParquetCompression compression;
        java.lang.Boolean enableDictionaryCompression;
        software.amazon.awscdk.Size maxPadding;
        software.amazon.awscdk.Size pageSize;
        software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion writerVersion;

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getBlockSize}
         * @param blockSize The Hadoop Distributed File System (HDFS) block size.
         *                  This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         *                  Firehose uses this value for padding calculations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockSize(software.amazon.awscdk.Size blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getCompression}
         * @param compression The compression code to use over data blocks.
         *                    The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code>.
         *                    Use <code>SNAPPY</code> for higher decompression speed.
         *                    Use <code>GZIP</code> if the compression ratio is more important than speed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getEnableDictionaryCompression}
         * @param enableDictionaryCompression Indicates whether to enable dictionary compression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDictionaryCompression(java.lang.Boolean enableDictionaryCompression) {
            this.enableDictionaryCompression = enableDictionaryCompression;
            return this;
        }

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getMaxPadding}
         * @param maxPadding The maximum amount of padding to apply.
         *                   This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPadding(software.amazon.awscdk.Size maxPadding) {
            this.maxPadding = maxPadding;
            return this;
        }

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getPageSize}
         * @param pageSize The Parquet page size.
         *                 Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pageSize(software.amazon.awscdk.Size pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        /**
         * Sets the value of {@link ParquetOutputFormatProps#getWriterVersion}
         * @param writerVersion Indicates the version of Parquet to output.
         *                      The possible values are <code>V1</code> and <code>V2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writerVersion(software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion writerVersion) {
            this.writerVersion = writerVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParquetOutputFormatProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ParquetOutputFormatProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ParquetOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParquetOutputFormatProps {
        private final software.amazon.awscdk.Size blockSize;
        private final software.amazon.awscdk.services.kinesisfirehose.ParquetCompression compression;
        private final java.lang.Boolean enableDictionaryCompression;
        private final software.amazon.awscdk.Size maxPadding;
        private final software.amazon.awscdk.Size pageSize;
        private final software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion writerVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blockSize = software.amazon.jsii.Kernel.get(this, "blockSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetCompression.class));
            this.enableDictionaryCompression = software.amazon.jsii.Kernel.get(this, "enableDictionaryCompression", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxPadding = software.amazon.jsii.Kernel.get(this, "maxPadding", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.pageSize = software.amazon.jsii.Kernel.get(this, "pageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.writerVersion = software.amazon.jsii.Kernel.get(this, "writerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blockSize = builder.blockSize;
            this.compression = builder.compression;
            this.enableDictionaryCompression = builder.enableDictionaryCompression;
            this.maxPadding = builder.maxPadding;
            this.pageSize = builder.pageSize;
            this.writerVersion = builder.writerVersion;
        }

        @Override
        public final software.amazon.awscdk.Size getBlockSize() {
            return this.blockSize;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.ParquetCompression getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.Boolean getEnableDictionaryCompression() {
            return this.enableDictionaryCompression;
        }

        @Override
        public final software.amazon.awscdk.Size getMaxPadding() {
            return this.maxPadding;
        }

        @Override
        public final software.amazon.awscdk.Size getPageSize() {
            return this.pageSize;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion getWriterVersion() {
            return this.writerVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBlockSize() != null) {
                data.set("blockSize", om.valueToTree(this.getBlockSize()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getEnableDictionaryCompression() != null) {
                data.set("enableDictionaryCompression", om.valueToTree(this.getEnableDictionaryCompression()));
            }
            if (this.getMaxPadding() != null) {
                data.set("maxPadding", om.valueToTree(this.getMaxPadding()));
            }
            if (this.getPageSize() != null) {
                data.set("pageSize", om.valueToTree(this.getPageSize()));
            }
            if (this.getWriterVersion() != null) {
                data.set("writerVersion", om.valueToTree(this.getWriterVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.ParquetOutputFormatProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParquetOutputFormatProps.Jsii$Proxy that = (ParquetOutputFormatProps.Jsii$Proxy) o;

            if (this.blockSize != null ? !this.blockSize.equals(that.blockSize) : that.blockSize != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.enableDictionaryCompression != null ? !this.enableDictionaryCompression.equals(that.enableDictionaryCompression) : that.enableDictionaryCompression != null) return false;
            if (this.maxPadding != null ? !this.maxPadding.equals(that.maxPadding) : that.maxPadding != null) return false;
            if (this.pageSize != null ? !this.pageSize.equals(that.pageSize) : that.pageSize != null) return false;
            return this.writerVersion != null ? this.writerVersion.equals(that.writerVersion) : that.writerVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blockSize != null ? this.blockSize.hashCode() : 0;
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.enableDictionaryCompression != null ? this.enableDictionaryCompression.hashCode() : 0);
            result = 31 * result + (this.maxPadding != null ? this.maxPadding.hashCode() : 0);
            result = 31 * result + (this.pageSize != null ? this.pageSize.hashCode() : 0);
            result = 31 * result + (this.writerVersion != null ? this.writerVersion.hashCode() : 0);
            return result;
        }
    }
}
